/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hashing;
import com.google.common.hash.LongAddable;
import com.google.common.hash.LongAddables;
import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLongArray;
import org.checkerframework.checker.nullness.qual.Nullable;

enum BloomFilterStrategies implements BloomFilter.Strategy
{
    MURMUR128_MITZ_32{

        @Override
        public <T> boolean put(T t2, Funnel<? super T> funnel, int n2, LockFreeBitArray lockFreeBitArray) {
            long l2 = lockFreeBitArray.bitSize();
            long l3 = Hashing.murmur3_128().hashObject(t2, funnel).asLong();
            int n3 = (int)l3;
            int n4 = (int)(l3 >>> 32);
            boolean bl2 = false;
            for (int i2 = 1; i2 <= n2; ++i2) {
                int n5 = n3 + i2 * n4;
                if (n5 < 0) {
                    n5 ^= 0xFFFFFFFF;
                }
                bl2 |= lockFreeBitArray.set((long)n5 % l2);
            }
            return bl2;
        }

        @Override
        public <T> boolean mightContain(T t2, Funnel<? super T> funnel, int n2, LockFreeBitArray lockFreeBitArray) {
            long l2 = lockFreeBitArray.bitSize();
            long l3 = Hashing.murmur3_128().hashObject(t2, funnel).asLong();
            int n3 = (int)l3;
            int n4 = (int)(l3 >>> 32);
            for (int i2 = 1; i2 <= n2; ++i2) {
                int n5 = n3 + i2 * n4;
                if (n5 < 0) {
                    n5 ^= 0xFFFFFFFF;
                }
                if (lockFreeBitArray.get((long)n5 % l2)) continue;
                return false;
            }
            return true;
        }
    }
    ,
    MURMUR128_MITZ_64{

        @Override
        public <T> boolean put(T t2, Funnel<? super T> funnel, int n2, LockFreeBitArray lockFreeBitArray) {
            long l2 = lockFreeBitArray.bitSize();
            byte[] byArray = Hashing.murmur3_128().hashObject(t2, funnel).getBytesInternal();
            long l3 = this.lowerEight(byArray);
            long l4 = this.upperEight(byArray);
            boolean bl2 = false;
            long l5 = l3;
            for (int i2 = 0; i2 < n2; ++i2) {
                bl2 |= lockFreeBitArray.set((l5 & Long.MAX_VALUE) % l2);
                l5 += l4;
            }
            return bl2;
        }

        @Override
        public <T> boolean mightContain(T t2, Funnel<? super T> funnel, int n2, LockFreeBitArray lockFreeBitArray) {
            long l2 = lockFreeBitArray.bitSize();
            byte[] byArray = Hashing.murmur3_128().hashObject(t2, funnel).getBytesInternal();
            long l3 = this.lowerEight(byArray);
            long l4 = this.upperEight(byArray);
            long l5 = l3;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!lockFreeBitArray.get((l5 & Long.MAX_VALUE) % l2)) {
                    return false;
                }
                l5 += l4;
            }
            return true;
        }

        private long lowerEight(byte[] byArray) {
            return Longs.fromBytes(byArray[7], byArray[6], byArray[5], byArray[4], byArray[3], byArray[2], byArray[1], byArray[0]);
        }

        private long upperEight(byte[] byArray) {
            return Longs.fromBytes(byArray[15], byArray[14], byArray[13], byArray[12], byArray[11], byArray[10], byArray[9], byArray[8]);
        }
    };


    static final class LockFreeBitArray {
        private static final int LONG_ADDRESSABLE_BITS = 6;
        final AtomicLongArray data;
        private final LongAddable bitCount;

        LockFreeBitArray(long l2) {
            Preconditions.checkArgument(l2 > 0L, "data length is zero!");
            this.data = new AtomicLongArray(Ints.checkedCast(LongMath.divide(l2, 64L, RoundingMode.CEILING)));
            this.bitCount = LongAddables.create();
        }

        LockFreeBitArray(long[] lArray) {
            Preconditions.checkArgument(lArray.length > 0, "data length is zero!");
            this.data = new AtomicLongArray(lArray);
            this.bitCount = LongAddables.create();
            long l2 = 0L;
            for (long l3 : lArray) {
                l2 += (long)Long.bitCount(l3);
            }
            this.bitCount.add(l2);
        }

        boolean set(long l2) {
            long l3;
            long l4;
            if (this.get(l2)) {
                return false;
            }
            int n2 = (int)(l2 >>> 6);
            long l5 = 1L << (int)l2;
            do {
                if ((l4 = this.data.get(n2)) != (l3 = l4 | l5)) continue;
                return false;
            } while (!this.data.compareAndSet(n2, l4, l3));
            this.bitCount.increment();
            return true;
        }

        boolean get(long l2) {
            return (this.data.get((int)(l2 >>> 6)) & 1L << (int)l2) != 0L;
        }

        public static long[] toPlainArray(AtomicLongArray atomicLongArray) {
            long[] lArray = new long[atomicLongArray.length()];
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                lArray[i2] = atomicLongArray.get(i2);
            }
            return lArray;
        }

        long bitSize() {
            return (long)this.data.length() * 64L;
        }

        long bitCount() {
            return this.bitCount.sum();
        }

        LockFreeBitArray copy() {
            return new LockFreeBitArray(LockFreeBitArray.toPlainArray(this.data));
        }

        void putAll(LockFreeBitArray lockFreeBitArray) {
            Preconditions.checkArgument(this.data.length() == lockFreeBitArray.data.length(), "BitArrays must be of equal length (%s != %s)", this.data.length(), lockFreeBitArray.data.length());
            for (int i2 = 0; i2 < this.data.length(); ++i2) {
                long l2;
                long l3;
                long l4 = lockFreeBitArray.data.get(i2);
                boolean bl2 = true;
                do {
                    if ((l3 = this.data.get(i2)) != (l2 = l3 | l4)) continue;
                    bl2 = false;
                    break;
                } while (!this.data.compareAndSet(i2, l3, l2));
                if (!bl2) continue;
                int n2 = Long.bitCount(l2) - Long.bitCount(l3);
                this.bitCount.add(n2);
            }
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof LockFreeBitArray) {
                LockFreeBitArray lockFreeBitArray = (LockFreeBitArray)object;
                return Arrays.equals(LockFreeBitArray.toPlainArray(this.data), LockFreeBitArray.toPlainArray(lockFreeBitArray.data));
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(LockFreeBitArray.toPlainArray(this.data));
        }
    }
}

