/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hasher;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@CanIgnoreReturnValue
abstract class AbstractHasher
implements Hasher {
    AbstractHasher() {
    }

    @Override
    public final Hasher putBoolean(boolean bl2) {
        return this.putByte(bl2 ? (byte)1 : 0);
    }

    @Override
    public final Hasher putDouble(double d2) {
        return this.putLong(Double.doubleToRawLongBits(d2));
    }

    @Override
    public final Hasher putFloat(float f2) {
        return this.putInt(Float.floatToRawIntBits(f2));
    }

    @Override
    public Hasher putUnencodedChars(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.putChar(charSequence.charAt(i2));
        }
        return this;
    }

    @Override
    public Hasher putString(CharSequence charSequence, Charset charset) {
        return this.putBytes(charSequence.toString().getBytes(charset));
    }

    @Override
    public Hasher putBytes(byte[] byArray) {
        return this.putBytes(byArray, 0, byArray.length);
    }

    @Override
    public Hasher putBytes(byte[] byArray, int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.putByte(byArray[n2 + i2]);
        }
        return this;
    }

    @Override
    public Hasher putBytes(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            this.putBytes(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(byteBuffer.limit());
        } else {
            for (int i2 = byteBuffer.remaining(); i2 > 0; --i2) {
                this.putByte(byteBuffer.get());
            }
        }
        return this;
    }

    @Override
    public Hasher putShort(short s2) {
        this.putByte((byte)s2);
        this.putByte((byte)(s2 >>> 8));
        return this;
    }

    @Override
    public Hasher putInt(int n2) {
        this.putByte((byte)n2);
        this.putByte((byte)(n2 >>> 8));
        this.putByte((byte)(n2 >>> 16));
        this.putByte((byte)(n2 >>> 24));
        return this;
    }

    @Override
    public Hasher putLong(long l2) {
        for (int i2 = 0; i2 < 64; i2 += 8) {
            this.putByte((byte)(l2 >>> i2));
        }
        return this;
    }

    @Override
    public Hasher putChar(char c2) {
        this.putByte((byte)c2);
        this.putByte((byte)(c2 >>> 8));
        return this;
    }

    @Override
    public <T> Hasher putObject(T t2, Funnel<? super T> funnel) {
        funnel.funnel(t2, this);
        return this;
    }
}

