/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.errorprone.annotations.Immutable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@Immutable
abstract class AbstractHashFunction
implements HashFunction {
    AbstractHashFunction() {
    }

    @Override
    public <T> HashCode hashObject(T t2, Funnel<? super T> funnel) {
        return this.newHasher().putObject(t2, funnel).hash();
    }

    @Override
    public HashCode hashUnencodedChars(CharSequence charSequence) {
        int n2 = charSequence.length();
        return this.newHasher(n2 * 2).putUnencodedChars(charSequence).hash();
    }

    @Override
    public HashCode hashString(CharSequence charSequence, Charset charset) {
        return this.newHasher().putString(charSequence, charset).hash();
    }

    @Override
    public HashCode hashInt(int n2) {
        return this.newHasher(4).putInt(n2).hash();
    }

    @Override
    public HashCode hashLong(long l2) {
        return this.newHasher(8).putLong(l2).hash();
    }

    @Override
    public HashCode hashBytes(byte[] byArray) {
        return this.hashBytes(byArray, 0, byArray.length);
    }

    @Override
    public HashCode hashBytes(byte[] byArray, int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
        return this.newHasher(n3).putBytes(byArray, n2, n3).hash();
    }

    @Override
    public HashCode hashBytes(ByteBuffer byteBuffer) {
        return this.newHasher(byteBuffer.remaining()).putBytes(byteBuffer).hash();
    }

    @Override
    public Hasher newHasher(int n2) {
        Preconditions.checkArgument(n2 >= 0, "expectedInputSize must be >= 0 but was %s", n2);
        return this.newHasher();
    }
}

