/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.errorprone.annotations.Immutable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@Immutable
abstract class AbstractCompositeHashFunction
extends AbstractHashFunction {
    final HashFunction[] functions;
    private static final long serialVersionUID = 0L;

    AbstractCompositeHashFunction(HashFunction ... hashFunctionArray) {
        for (HashFunction hashFunction : hashFunctionArray) {
            Preconditions.checkNotNull(hashFunction);
        }
        this.functions = hashFunctionArray;
    }

    abstract HashCode makeHash(Hasher[] var1);

    @Override
    public Hasher newHasher() {
        Hasher[] hasherArray = new Hasher[this.functions.length];
        for (int i2 = 0; i2 < hasherArray.length; ++i2) {
            hasherArray[i2] = this.functions[i2].newHasher();
        }
        return this.fromHashers(hasherArray);
    }

    @Override
    public Hasher newHasher(int n2) {
        Preconditions.checkArgument(n2 >= 0);
        Hasher[] hasherArray = new Hasher[this.functions.length];
        for (int i2 = 0; i2 < hasherArray.length; ++i2) {
            hasherArray[i2] = this.functions[i2].newHasher(n2);
        }
        return this.fromHashers(hasherArray);
    }

    private Hasher fromHashers(final Hasher[] hasherArray) {
        return new Hasher(){

            @Override
            public Hasher putByte(byte by2) {
                for (Hasher hasher : hasherArray) {
                    hasher.putByte(by2);
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] byArray) {
                for (Hasher hasher : hasherArray) {
                    hasher.putBytes(byArray);
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] byArray, int n2, int n3) {
                for (Hasher hasher : hasherArray) {
                    hasher.putBytes(byArray, n2, n3);
                }
                return this;
            }

            @Override
            public Hasher putBytes(ByteBuffer byteBuffer) {
                int n2 = byteBuffer.position();
                for (Hasher hasher : hasherArray) {
                    byteBuffer.position(n2);
                    hasher.putBytes(byteBuffer);
                }
                return this;
            }

            @Override
            public Hasher putShort(short s2) {
                for (Hasher hasher : hasherArray) {
                    hasher.putShort(s2);
                }
                return this;
            }

            @Override
            public Hasher putInt(int n2) {
                for (Hasher hasher : hasherArray) {
                    hasher.putInt(n2);
                }
                return this;
            }

            @Override
            public Hasher putLong(long l2) {
                for (Hasher hasher : hasherArray) {
                    hasher.putLong(l2);
                }
                return this;
            }

            @Override
            public Hasher putFloat(float f2) {
                for (Hasher hasher : hasherArray) {
                    hasher.putFloat(f2);
                }
                return this;
            }

            @Override
            public Hasher putDouble(double d2) {
                for (Hasher hasher : hasherArray) {
                    hasher.putDouble(d2);
                }
                return this;
            }

            @Override
            public Hasher putBoolean(boolean bl2) {
                for (Hasher hasher : hasherArray) {
                    hasher.putBoolean(bl2);
                }
                return this;
            }

            @Override
            public Hasher putChar(char c2) {
                for (Hasher hasher : hasherArray) {
                    hasher.putChar(c2);
                }
                return this;
            }

            @Override
            public Hasher putUnencodedChars(CharSequence charSequence) {
                for (Hasher hasher : hasherArray) {
                    hasher.putUnencodedChars(charSequence);
                }
                return this;
            }

            @Override
            public Hasher putString(CharSequence charSequence, Charset charset) {
                for (Hasher hasher : hasherArray) {
                    hasher.putString(charSequence, charset);
                }
                return this;
            }

            @Override
            public <T> Hasher putObject(T t2, Funnel<? super T> funnel) {
                for (Hasher hasher : hasherArray) {
                    hasher.putObject(t2, funnel);
                }
                return this;
            }

            @Override
            public HashCode hash() {
                return AbstractCompositeHashFunction.this.makeHash(hasherArray);
            }
        };
    }
}

