/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.Hasher;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@CanIgnoreReturnValue
abstract class AbstractByteHasher
extends AbstractHasher {
    private final ByteBuffer scratch = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);

    AbstractByteHasher() {
    }

    protected abstract void update(byte var1);

    protected void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    protected void update(byte[] byArray, int n2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            this.update(byArray[i2]);
        }
    }

    protected void update(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            this.update(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(byteBuffer.limit());
        } else {
            for (int i2 = byteBuffer.remaining(); i2 > 0; --i2) {
                this.update(byteBuffer.get());
            }
        }
    }

    private Hasher update(int n2) {
        try {
            this.update(this.scratch.array(), 0, n2);
        }
        finally {
            this.scratch.clear();
        }
        return this;
    }

    @Override
    public Hasher putByte(byte by2) {
        this.update(by2);
        return this;
    }

    @Override
    public Hasher putBytes(byte[] byArray) {
        Preconditions.checkNotNull(byArray);
        this.update(byArray);
        return this;
    }

    @Override
    public Hasher putBytes(byte[] byArray, int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
        this.update(byArray, n2, n3);
        return this;
    }

    @Override
    public Hasher putBytes(ByteBuffer byteBuffer) {
        this.update(byteBuffer);
        return this;
    }

    @Override
    public Hasher putShort(short s2) {
        this.scratch.putShort(s2);
        return this.update(2);
    }

    @Override
    public Hasher putInt(int n2) {
        this.scratch.putInt(n2);
        return this.update(4);
    }

    @Override
    public Hasher putLong(long l2) {
        this.scratch.putLong(l2);
        return this.update(8);
    }

    @Override
    public Hasher putChar(char c2) {
        this.scratch.putChar(c2);
        return this.update(2);
    }
}

