/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import com.google.common.graph.AbstractUndirectedNetworkConnections;
import com.google.common.graph.MultiEdgesConnecting;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

final class UndirectedMultiNetworkConnections<N, E>
extends AbstractUndirectedNetworkConnections<N, E> {
    @LazyInit
    private transient Reference<Multiset<N>> adjacentNodesReference;

    private UndirectedMultiNetworkConnections(Map<E, N> map) {
        super(map);
    }

    static <N, E> UndirectedMultiNetworkConnections<N, E> of() {
        return new UndirectedMultiNetworkConnections(new HashMap(2, 1.0f));
    }

    static <N, E> UndirectedMultiNetworkConnections<N, E> ofImmutable(Map<E, N> map) {
        return new UndirectedMultiNetworkConnections<N, E>(ImmutableMap.copyOf(map));
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(this.adjacentNodesMultiset().elementSet());
    }

    private Multiset<N> adjacentNodesMultiset() {
        Multiset<N> multiset = UndirectedMultiNetworkConnections.getReference(this.adjacentNodesReference);
        if (multiset == null) {
            multiset = HashMultiset.create(this.incidentEdgeMap.values());
            this.adjacentNodesReference = new SoftReference<Multiset<N>>(multiset);
        }
        return multiset;
    }

    @Override
    public Set<E> edgesConnecting(final N n2) {
        return new MultiEdgesConnecting<E>(this.incidentEdgeMap, n2){

            @Override
            public int size() {
                return UndirectedMultiNetworkConnections.this.adjacentNodesMultiset().count(n2);
            }
        };
    }

    @Override
    public N removeInEdge(E e2, boolean bl2) {
        if (!bl2) {
            return this.removeOutEdge(e2);
        }
        return null;
    }

    @Override
    public N removeOutEdge(E e2) {
        Object n2 = super.removeOutEdge(e2);
        Multiset<N> multiset = UndirectedMultiNetworkConnections.getReference(this.adjacentNodesReference);
        if (multiset != null) {
            Preconditions.checkState(multiset.remove(n2));
        }
        return n2;
    }

    @Override
    public void addInEdge(E e2, N n2, boolean bl2) {
        if (!bl2) {
            this.addOutEdge(e2, n2);
        }
    }

    @Override
    public void addOutEdge(E e2, N n2) {
        super.addOutEdge(e2, n2);
        Multiset<N> multiset = UndirectedMultiNetworkConnections.getReference(this.adjacentNodesReference);
        if (multiset != null) {
            Preconditions.checkState(multiset.add(n2));
        }
    }

    private static <T> @Nullable T getReference(@Nullable Reference<T> reference) {
        return reference == null ? null : (T)reference.get();
    }
}

