/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.MapIteratorCache;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

class MapRetrievalCache<K, V>
extends MapIteratorCache<K, V> {
    private transient @Nullable CacheEntry<K, V> cacheEntry1;
    private transient @Nullable CacheEntry<K, V> cacheEntry2;

    MapRetrievalCache(Map<K, V> map) {
        super(map);
    }

    @Override
    public V get(@Nullable Object object) {
        V v2 = this.getIfCached(object);
        if (v2 != null) {
            return v2;
        }
        v2 = this.getWithoutCaching(object);
        if (v2 != null) {
            this.addToCache(object, v2);
        }
        return v2;
    }

    @Override
    protected V getIfCached(@Nullable Object object) {
        Object v2 = super.getIfCached(object);
        if (v2 != null) {
            return v2;
        }
        CacheEntry<K, V> cacheEntry = this.cacheEntry1;
        if (cacheEntry != null && cacheEntry.key == object) {
            return cacheEntry.value;
        }
        cacheEntry = this.cacheEntry2;
        if (cacheEntry != null && cacheEntry.key == object) {
            this.addToCache(cacheEntry);
            return cacheEntry.value;
        }
        return null;
    }

    @Override
    protected void clearCache() {
        super.clearCache();
        this.cacheEntry1 = null;
        this.cacheEntry2 = null;
    }

    private void addToCache(K k2, V v2) {
        this.addToCache(new CacheEntry<K, V>(k2, v2));
    }

    private void addToCache(CacheEntry<K, V> cacheEntry) {
        this.cacheEntry2 = this.cacheEntry1;
        this.cacheEntry1 = cacheEntry;
    }

    private static final class CacheEntry<K, V> {
        final K key;
        final V value;

        CacheEntry(K k2, V v2) {
            this.key = k2;
            this.value = v2;
        }
    }
}

