/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.graph.ConfigurableNetwork;
import com.google.common.graph.DirectedMultiNetworkConnections;
import com.google.common.graph.DirectedNetworkConnections;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NetworkConnections;
import com.google.common.graph.UndirectedMultiNetworkConnections;
import com.google.common.graph.UndirectedNetworkConnections;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.util.Map;

@Immutable(containerOf={"N", "E"})
@Beta
public final class ImmutableNetwork<N, E>
extends ConfigurableNetwork<N, E> {
    private ImmutableNetwork(Network<N, E> network) {
        super(NetworkBuilder.from(network), ImmutableNetwork.getNodeConnections(network), ImmutableNetwork.getEdgeToReferenceNode(network));
    }

    public static <N, E> ImmutableNetwork<N, E> copyOf(Network<N, E> network) {
        return network instanceof ImmutableNetwork ? (ImmutableNetwork<N, E>)network : new ImmutableNetwork<N, E>(network);
    }

    @Deprecated
    public static <N, E> ImmutableNetwork<N, E> copyOf(ImmutableNetwork<N, E> immutableNetwork) {
        return Preconditions.checkNotNull(immutableNetwork);
    }

    @Override
    public ImmutableGraph<N> asGraph() {
        return new ImmutableGraph(super.asGraph());
    }

    private static <N, E> Map<N, NetworkConnections<N, E>> getNodeConnections(Network<N, E> network) {
        ImmutableMap.Builder<N, NetworkConnections<N, E>> builder = ImmutableMap.builder();
        for (N n2 : network.nodes()) {
            builder.put(n2, ImmutableNetwork.connectionsOf(network, n2));
        }
        return builder.build();
    }

    private static <N, E> Map<E, N> getEdgeToReferenceNode(Network<N, E> network) {
        ImmutableMap.Builder<E, N> builder = ImmutableMap.builder();
        for (E e2 : network.edges()) {
            builder.put(e2, network.incidentNodes(e2).nodeU());
        }
        return builder.build();
    }

    private static <N, E> NetworkConnections<N, E> connectionsOf(Network<N, E> network, N n2) {
        if (network.isDirected()) {
            Map<E, N> map = Maps.asMap(network.inEdges(n2), ImmutableNetwork.sourceNodeFn(network));
            Map<E, N> map2 = Maps.asMap(network.outEdges(n2), ImmutableNetwork.targetNodeFn(network));
            int n3 = network.edgesConnecting(n2, n2).size();
            return network.allowsParallelEdges() ? DirectedMultiNetworkConnections.ofImmutable(map, map2, n3) : DirectedNetworkConnections.ofImmutable(map, map2, n3);
        }
        Map<E, N> map = Maps.asMap(network.incidentEdges(n2), ImmutableNetwork.adjacentNodeFn(network, n2));
        return network.allowsParallelEdges() ? UndirectedMultiNetworkConnections.ofImmutable(map) : UndirectedNetworkConnections.ofImmutable(map);
    }

    private static <N, E> Function<E, N> sourceNodeFn(final Network<N, E> network) {
        return new Function<E, N>(){

            @Override
            public N apply(E e2) {
                return network.incidentNodes(e2).source();
            }
        };
    }

    private static <N, E> Function<E, N> targetNodeFn(final Network<N, E> network) {
        return new Function<E, N>(){

            @Override
            public N apply(E e2) {
                return network.incidentNodes(e2).target();
            }
        };
    }

    private static <N, E> Function<E, N> adjacentNodeFn(final Network<N, E> network, final N n2) {
        return new Function<E, N>(){

            @Override
            public N apply(E e2) {
                return network.incidentNodes(e2).adjacentNode(n2);
            }
        };
    }

    public static class Builder<N, E> {
        private final MutableNetwork<N, E> mutableNetwork;

        Builder(NetworkBuilder<N, E> networkBuilder) {
            this.mutableNetwork = networkBuilder.build();
        }

        @CanIgnoreReturnValue
        public Builder<N, E> addNode(N n2) {
            this.mutableNetwork.addNode(n2);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N, E> addEdge(N n2, N n3, E e2) {
            this.mutableNetwork.addEdge(n2, n3, e2);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N, E> addEdge(EndpointPair<N> endpointPair, E e2) {
            this.mutableNetwork.addEdge(endpointPair, e2);
            return this;
        }

        public ImmutableNetwork<N, E> build() {
            return ImmutableNetwork.copyOf(this.mutableNetwork);
        }
    }
}

