/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ForwardingGraph;
import com.google.common.graph.ForwardingNetwork;
import com.google.common.graph.ForwardingValueGraph;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.Traverser;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
public final class Graphs {
    private Graphs() {
    }

    public static <N> boolean hasCycle(Graph<N> graph) {
        int n2 = graph.edges().size();
        if (n2 == 0) {
            return false;
        }
        if (!graph.isDirected() && n2 >= graph.nodes().size()) {
            return true;
        }
        HashMap<Object, NodeVisitState> hashMap = Maps.newHashMapWithExpectedSize(graph.nodes().size());
        for (N n3 : graph.nodes()) {
            if (!Graphs.subgraphHasCycle(graph, hashMap, n3, null)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCycle(Network<?, ?> network) {
        if (!network.isDirected() && network.allowsParallelEdges() && network.edges().size() > network.asGraph().edges().size()) {
            return true;
        }
        return Graphs.hasCycle(network.asGraph());
    }

    private static <N> boolean subgraphHasCycle(Graph<N> graph, Map<Object, NodeVisitState> map, N n2, @Nullable N n3) {
        NodeVisitState nodeVisitState = map.get(n2);
        if (nodeVisitState == NodeVisitState.COMPLETE) {
            return false;
        }
        if (nodeVisitState == NodeVisitState.PENDING) {
            return true;
        }
        map.put(n2, NodeVisitState.PENDING);
        for (Object e2 : graph.successors((Object)n2)) {
            if (!Graphs.canTraverseWithoutReusingEdge(graph, e2, n3) || !Graphs.subgraphHasCycle(graph, map, e2, n2)) continue;
            return true;
        }
        map.put(n2, NodeVisitState.COMPLETE);
        return false;
    }

    private static boolean canTraverseWithoutReusingEdge(Graph<?> graph, Object object, @Nullable Object object2) {
        return graph.isDirected() || !Objects.equal(object2, object);
    }

    public static <N> Graph<N> transitiveClosure(Graph<N> graph) {
        MutableGraph mutableGraph = GraphBuilder.from(graph).allowsSelfLoops(true).build();
        if (graph.isDirected()) {
            for (N n2 : graph.nodes()) {
                for (N n3 : Graphs.reachableNodes(graph, n2)) {
                    mutableGraph.putEdge(n2, n3);
                }
            }
        } else {
            HashSet<N> hashSet = new HashSet<N>();
            for (N n4 : graph.nodes()) {
                if (hashSet.contains(n4)) continue;
                Set<N> set = Graphs.reachableNodes(graph, n4);
                hashSet.addAll(set);
                int n5 = 1;
                for (N n6 : set) {
                    for (N n7 : Iterables.limit(set, n5++)) {
                        mutableGraph.putEdge(n6, n7);
                    }
                }
            }
        }
        return mutableGraph;
    }

    public static <N> Set<N> reachableNodes(Graph<N> graph, N n2) {
        Preconditions.checkArgument(graph.nodes().contains(n2), "Node %s is not an element of this graph.", n2);
        return ImmutableSet.copyOf(Traverser.forGraph(graph).breadthFirst(n2));
    }

    public static <N> Graph<N> transpose(Graph<N> graph) {
        if (!graph.isDirected()) {
            return graph;
        }
        if (graph instanceof TransposedGraph) {
            return ((TransposedGraph)graph).graph;
        }
        return new TransposedGraph<N>(graph);
    }

    public static <N, V> ValueGraph<N, V> transpose(ValueGraph<N, V> valueGraph) {
        if (!valueGraph.isDirected()) {
            return valueGraph;
        }
        if (valueGraph instanceof TransposedValueGraph) {
            return ((TransposedValueGraph)valueGraph).graph;
        }
        return new TransposedValueGraph<N, V>(valueGraph);
    }

    public static <N, E> Network<N, E> transpose(Network<N, E> network) {
        if (!network.isDirected()) {
            return network;
        }
        if (network instanceof TransposedNetwork) {
            return ((TransposedNetwork)network).network;
        }
        return new TransposedNetwork<N, E>(network);
    }

    static <N> EndpointPair<N> transpose(EndpointPair<N> endpointPair) {
        if (endpointPair.isOrdered()) {
            return EndpointPair.ordered(endpointPair.target(), endpointPair.source());
        }
        return endpointPair;
    }

    public static <N> MutableGraph<N> inducedSubgraph(Graph<N> graph, Iterable<? extends N> iterable) {
        MutableGraph mutableGraph = iterable instanceof Collection ? GraphBuilder.from(graph).expectedNodeCount(((Collection)iterable).size()).build() : GraphBuilder.from(graph).build();
        for (Object object : iterable) {
            mutableGraph.addNode(object);
        }
        for (Object object : mutableGraph.nodes()) {
            for (Object e2 : graph.successors(object)) {
                if (!mutableGraph.nodes().contains(e2)) continue;
                mutableGraph.putEdge(object, e2);
            }
        }
        return mutableGraph;
    }

    public static <N, V> MutableValueGraph<N, V> inducedSubgraph(ValueGraph<N, V> valueGraph, Iterable<? extends N> iterable) {
        MutableValueGraph mutableValueGraph = iterable instanceof Collection ? ValueGraphBuilder.from(valueGraph).expectedNodeCount(((Collection)iterable).size()).build() : ValueGraphBuilder.from(valueGraph).build();
        for (Object object : iterable) {
            mutableValueGraph.addNode(object);
        }
        for (Object object : mutableValueGraph.nodes()) {
            for (Object e2 : valueGraph.successors(object)) {
                if (!mutableValueGraph.nodes().contains(e2)) continue;
                mutableValueGraph.putEdgeValue(object, e2, valueGraph.edgeValueOrDefault(object, e2, null));
            }
        }
        return mutableValueGraph;
    }

    public static <N, E> MutableNetwork<N, E> inducedSubgraph(Network<N, E> network, Iterable<? extends N> iterable) {
        MutableNetwork mutableNetwork = iterable instanceof Collection ? NetworkBuilder.from(network).expectedNodeCount(((Collection)iterable).size()).build() : NetworkBuilder.from(network).build();
        for (Object object : iterable) {
            mutableNetwork.addNode(object);
        }
        for (Object object : mutableNetwork.nodes()) {
            for (E e2 : network.outEdges(object)) {
                N n2 = network.incidentNodes(e2).adjacentNode(object);
                if (!mutableNetwork.nodes().contains(n2)) continue;
                mutableNetwork.addEdge(object, n2, e2);
            }
        }
        return mutableNetwork;
    }

    public static <N> MutableGraph<N> copyOf(Graph<N> graph) {
        MutableGraph mutableGraph = GraphBuilder.from(graph).expectedNodeCount(graph.nodes().size()).build();
        for (N object : graph.nodes()) {
            mutableGraph.addNode(object);
        }
        for (EndpointPair endpointPair : graph.edges()) {
            mutableGraph.putEdge(endpointPair.nodeU(), endpointPair.nodeV());
        }
        return mutableGraph;
    }

    public static <N, V> MutableValueGraph<N, V> copyOf(ValueGraph<N, V> valueGraph) {
        MutableValueGraph mutableValueGraph = ValueGraphBuilder.from(valueGraph).expectedNodeCount(valueGraph.nodes().size()).build();
        for (Object object : valueGraph.nodes()) {
            mutableValueGraph.addNode(object);
        }
        for (EndpointPair endpointPair : valueGraph.edges()) {
            mutableValueGraph.putEdgeValue(endpointPair.nodeU(), endpointPair.nodeV(), valueGraph.edgeValueOrDefault(endpointPair.nodeU(), endpointPair.nodeV(), null));
        }
        return mutableValueGraph;
    }

    public static <N, E> MutableNetwork<N, E> copyOf(Network<N, E> network) {
        MutableNetwork mutableNetwork = NetworkBuilder.from(network).expectedNodeCount(network.nodes().size()).expectedEdgeCount(network.edges().size()).build();
        for (Object object : network.nodes()) {
            mutableNetwork.addNode(object);
        }
        for (Object object : network.edges()) {
            EndpointPair<N> endpointPair = network.incidentNodes(object);
            mutableNetwork.addEdge(endpointPair.nodeU(), endpointPair.nodeV(), object);
        }
        return mutableNetwork;
    }

    @CanIgnoreReturnValue
    static int checkNonNegative(int n2) {
        Preconditions.checkArgument(n2 >= 0, "Not true that %s is non-negative.", n2);
        return n2;
    }

    @CanIgnoreReturnValue
    static long checkNonNegative(long l2) {
        Preconditions.checkArgument(l2 >= 0L, "Not true that %s is non-negative.", l2);
        return l2;
    }

    @CanIgnoreReturnValue
    static int checkPositive(int n2) {
        Preconditions.checkArgument(n2 > 0, "Not true that %s is positive.", n2);
        return n2;
    }

    @CanIgnoreReturnValue
    static long checkPositive(long l2) {
        Preconditions.checkArgument(l2 > 0L, "Not true that %s is positive.", l2);
        return l2;
    }

    private static enum NodeVisitState {
        PENDING,
        COMPLETE;

    }

    private static class TransposedNetwork<N, E>
    extends ForwardingNetwork<N, E> {
        private final Network<N, E> network;

        TransposedNetwork(Network<N, E> network) {
            this.network = network;
        }

        @Override
        protected Network<N, E> delegate() {
            return this.network;
        }

        @Override
        public Set<N> predecessors(N n2) {
            return this.delegate().successors((Object)n2);
        }

        @Override
        public Set<N> successors(N n2) {
            return this.delegate().predecessors((Object)n2);
        }

        @Override
        public int inDegree(N n2) {
            return this.delegate().outDegree(n2);
        }

        @Override
        public int outDegree(N n2) {
            return this.delegate().inDegree(n2);
        }

        @Override
        public Set<E> inEdges(N n2) {
            return this.delegate().outEdges(n2);
        }

        @Override
        public Set<E> outEdges(N n2) {
            return this.delegate().inEdges(n2);
        }

        @Override
        public EndpointPair<N> incidentNodes(E e2) {
            EndpointPair<N> endpointPair = this.delegate().incidentNodes(e2);
            return EndpointPair.of(this.network, endpointPair.nodeV(), endpointPair.nodeU());
        }

        @Override
        public Set<E> edgesConnecting(N n2, N n3) {
            return this.delegate().edgesConnecting(n3, n2);
        }

        @Override
        public Set<E> edgesConnecting(EndpointPair<N> endpointPair) {
            return this.delegate().edgesConnecting(Graphs.transpose(endpointPair));
        }

        @Override
        public Optional<E> edgeConnecting(N n2, N n3) {
            return this.delegate().edgeConnecting(n3, n2);
        }

        @Override
        public Optional<E> edgeConnecting(EndpointPair<N> endpointPair) {
            return this.delegate().edgeConnecting(Graphs.transpose(endpointPair));
        }

        @Override
        public E edgeConnectingOrNull(N n2, N n3) {
            return this.delegate().edgeConnectingOrNull(n3, n2);
        }

        @Override
        public E edgeConnectingOrNull(EndpointPair<N> endpointPair) {
            return this.delegate().edgeConnectingOrNull(Graphs.transpose(endpointPair));
        }

        @Override
        public boolean hasEdgeConnecting(N n2, N n3) {
            return this.delegate().hasEdgeConnecting(n3, n2);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpointPair));
        }
    }

    private static class TransposedValueGraph<N, V>
    extends ForwardingValueGraph<N, V> {
        private final ValueGraph<N, V> graph;

        TransposedValueGraph(ValueGraph<N, V> valueGraph) {
            this.graph = valueGraph;
        }

        @Override
        protected ValueGraph<N, V> delegate() {
            return this.graph;
        }

        @Override
        public Set<N> predecessors(N n2) {
            return this.delegate().successors((Object)n2);
        }

        @Override
        public Set<N> successors(N n2) {
            return this.delegate().predecessors((Object)n2);
        }

        @Override
        public int inDegree(N n2) {
            return this.delegate().outDegree(n2);
        }

        @Override
        public int outDegree(N n2) {
            return this.delegate().inDegree(n2);
        }

        @Override
        public boolean hasEdgeConnecting(N n2, N n3) {
            return this.delegate().hasEdgeConnecting(n3, n2);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpointPair));
        }

        @Override
        public Optional<V> edgeValue(N n2, N n3) {
            return this.delegate().edgeValue(n3, n2);
        }

        @Override
        public Optional<V> edgeValue(EndpointPair<N> endpointPair) {
            return this.delegate().edgeValue(Graphs.transpose(endpointPair));
        }

        @Override
        public @Nullable V edgeValueOrDefault(N n2, N n3, @Nullable V v2) {
            return this.delegate().edgeValueOrDefault(n3, n2, v2);
        }

        @Override
        public @Nullable V edgeValueOrDefault(EndpointPair<N> endpointPair, @Nullable V v2) {
            return this.delegate().edgeValueOrDefault(Graphs.transpose(endpointPair), v2);
        }
    }

    private static class TransposedGraph<N>
    extends ForwardingGraph<N> {
        private final Graph<N> graph;

        TransposedGraph(Graph<N> graph) {
            this.graph = graph;
        }

        @Override
        protected Graph<N> delegate() {
            return this.graph;
        }

        @Override
        public Set<N> predecessors(N n2) {
            return this.delegate().successors((Object)n2);
        }

        @Override
        public Set<N> successors(N n2) {
            return this.delegate().predecessors((Object)n2);
        }

        @Override
        public int inDegree(N n2) {
            return this.delegate().outDegree(n2);
        }

        @Override
        public int outDegree(N n2) {
            return this.delegate().inDegree(n2);
        }

        @Override
        public boolean hasEdgeConnecting(N n2, N n3) {
            return this.delegate().hasEdgeConnecting(n3, n2);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpointPair));
        }
    }
}

