/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractValueGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ValueGraph;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class ForwardingValueGraph<N, V>
extends AbstractValueGraph<N, V> {
    ForwardingValueGraph() {
    }

    protected abstract ValueGraph<N, V> delegate();

    @Override
    public Set<N> nodes() {
        return this.delegate().nodes();
    }

    @Override
    protected long edgeCount() {
        return this.delegate().edges().size();
    }

    @Override
    public boolean isDirected() {
        return this.delegate().isDirected();
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.delegate().allowsSelfLoops();
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.delegate().nodeOrder();
    }

    @Override
    public Set<N> adjacentNodes(N n2) {
        return this.delegate().adjacentNodes(n2);
    }

    @Override
    public Set<N> predecessors(N n2) {
        return this.delegate().predecessors((Object)n2);
    }

    @Override
    public Set<N> successors(N n2) {
        return this.delegate().successors((Object)n2);
    }

    @Override
    public int degree(N n2) {
        return this.delegate().degree(n2);
    }

    @Override
    public int inDegree(N n2) {
        return this.delegate().inDegree(n2);
    }

    @Override
    public int outDegree(N n2) {
        return this.delegate().outDegree(n2);
    }

    @Override
    public boolean hasEdgeConnecting(N n2, N n3) {
        return this.delegate().hasEdgeConnecting(n2, n3);
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
        return this.delegate().hasEdgeConnecting(endpointPair);
    }

    @Override
    public Optional<V> edgeValue(N n2, N n3) {
        return this.delegate().edgeValue(n2, n3);
    }

    @Override
    public Optional<V> edgeValue(EndpointPair<N> endpointPair) {
        return this.delegate().edgeValue(endpointPair);
    }

    @Override
    public @Nullable V edgeValueOrDefault(N n2, N n3, @Nullable V v2) {
        return this.delegate().edgeValueOrDefault(n2, n3, v2);
    }

    @Override
    public @Nullable V edgeValueOrDefault(EndpointPair<N> endpointPair, @Nullable V v2) {
        return this.delegate().edgeValueOrDefault(endpointPair, v2);
    }
}

