/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.Graphs;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

final class DirectedGraphConnections<N, V>
implements GraphConnections<N, V> {
    private static final Object PRED = new Object();
    private final Map<N, Object> adjacentNodeValues;
    private int predecessorCount;
    private int successorCount;

    private DirectedGraphConnections(Map<N, Object> map, int n2, int n3) {
        this.adjacentNodeValues = Preconditions.checkNotNull(map);
        this.predecessorCount = Graphs.checkNonNegative(n2);
        this.successorCount = Graphs.checkNonNegative(n3);
        Preconditions.checkState(n2 <= map.size() && n3 <= map.size());
    }

    static <N, V> DirectedGraphConnections<N, V> of() {
        int n2 = 4;
        return new DirectedGraphConnections(new HashMap(n2, 1.0f), 0, 0);
    }

    static <N, V> DirectedGraphConnections<N, V> ofImmutable(Set<N> set, Map<N, V> map) {
        HashMap<N, Object> hashMap = new HashMap<N, Object>();
        hashMap.putAll(map);
        for (N n2 : set) {
            Object object = hashMap.put(n2, PRED);
            if (object == null) continue;
            hashMap.put(n2, new PredAndSucc(object));
        }
        return new DirectedGraphConnections(ImmutableMap.copyOf(hashMap), set.size(), map.size());
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(this.adjacentNodeValues.keySet());
    }

    @Override
    public Set<N> predecessors() {
        return new AbstractSet<N>(){

            @Override
            public UnmodifiableIterator<N> iterator() {
                final Iterator iterator = DirectedGraphConnections.this.adjacentNodeValues.entrySet().iterator();
                return new AbstractIterator<N>(){

                    @Override
                    protected N computeNext() {
                        while (iterator.hasNext()) {
                            Map.Entry entry = (Map.Entry)iterator.next();
                            if (!DirectedGraphConnections.isPredecessor(entry.getValue())) continue;
                            return entry.getKey();
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                return DirectedGraphConnections.this.predecessorCount;
            }

            @Override
            public boolean contains(@Nullable Object object) {
                return DirectedGraphConnections.isPredecessor(DirectedGraphConnections.this.adjacentNodeValues.get(object));
            }
        };
    }

    @Override
    public Set<N> successors() {
        return new AbstractSet<N>(){

            @Override
            public UnmodifiableIterator<N> iterator() {
                final Iterator iterator = DirectedGraphConnections.this.adjacentNodeValues.entrySet().iterator();
                return new AbstractIterator<N>(){

                    @Override
                    protected N computeNext() {
                        while (iterator.hasNext()) {
                            Map.Entry entry = (Map.Entry)iterator.next();
                            if (!DirectedGraphConnections.isSuccessor(entry.getValue())) continue;
                            return entry.getKey();
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                return DirectedGraphConnections.this.successorCount;
            }

            @Override
            public boolean contains(@Nullable Object object) {
                return DirectedGraphConnections.isSuccessor(DirectedGraphConnections.this.adjacentNodeValues.get(object));
            }
        };
    }

    @Override
    public V value(N n2) {
        Object object = this.adjacentNodeValues.get(n2);
        if (object == PRED) {
            return null;
        }
        if (object instanceof PredAndSucc) {
            return (V)((PredAndSucc)object).successorValue;
        }
        return (V)object;
    }

    @Override
    public void removePredecessor(N n2) {
        Object object = this.adjacentNodeValues.get(n2);
        if (object == PRED) {
            this.adjacentNodeValues.remove(n2);
            Graphs.checkNonNegative(--this.predecessorCount);
        } else if (object instanceof PredAndSucc) {
            this.adjacentNodeValues.put(n2, ((PredAndSucc)object).successorValue);
            Graphs.checkNonNegative(--this.predecessorCount);
        }
    }

    @Override
    public V removeSuccessor(Object object) {
        Object object2 = this.adjacentNodeValues.get(object);
        if (object2 == null || object2 == PRED) {
            return null;
        }
        if (object2 instanceof PredAndSucc) {
            this.adjacentNodeValues.put(object, PRED);
            Graphs.checkNonNegative(--this.successorCount);
            return (V)((PredAndSucc)object2).successorValue;
        }
        this.adjacentNodeValues.remove(object);
        Graphs.checkNonNegative(--this.successorCount);
        return (V)object2;
    }

    @Override
    public void addPredecessor(N n2, V v2) {
        Object object = this.adjacentNodeValues.put(n2, PRED);
        if (object == null) {
            Graphs.checkPositive(++this.predecessorCount);
        } else if (object instanceof PredAndSucc) {
            this.adjacentNodeValues.put(n2, object);
        } else if (object != PRED) {
            this.adjacentNodeValues.put(n2, new PredAndSucc(object));
            Graphs.checkPositive(++this.predecessorCount);
        }
    }

    @Override
    public V addSuccessor(N n2, V v2) {
        Object object = this.adjacentNodeValues.put(n2, v2);
        if (object == null) {
            Graphs.checkPositive(++this.successorCount);
            return null;
        }
        if (object instanceof PredAndSucc) {
            this.adjacentNodeValues.put(n2, new PredAndSucc(v2));
            return (V)((PredAndSucc)object).successorValue;
        }
        if (object == PRED) {
            this.adjacentNodeValues.put(n2, new PredAndSucc(v2));
            Graphs.checkPositive(++this.successorCount);
            return null;
        }
        return (V)object;
    }

    private static boolean isPredecessor(@Nullable Object object) {
        return object == PRED || object instanceof PredAndSucc;
    }

    private static boolean isSuccessor(@Nullable Object object) {
        return object != PRED && object != null;
    }

    private static final class PredAndSucc {
        private final Object successorValue;

        PredAndSucc(Object object) {
            this.successorValue = object;
        }
    }
}

