/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.AbstractGraphBuilder;
import com.google.common.graph.AbstractValueGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.Graphs;
import com.google.common.graph.MapIteratorCache;
import com.google.common.graph.MapRetrievalCache;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.qual.Nullable;

class ConfigurableValueGraph<N, V>
extends AbstractValueGraph<N, V> {
    private final boolean isDirected;
    private final boolean allowsSelfLoops;
    private final ElementOrder<N> nodeOrder;
    protected final MapIteratorCache<N, GraphConnections<N, V>> nodeConnections;
    protected long edgeCount;

    ConfigurableValueGraph(AbstractGraphBuilder<? super N> abstractGraphBuilder) {
        this(abstractGraphBuilder, abstractGraphBuilder.nodeOrder.createMap(abstractGraphBuilder.expectedNodeCount.or(10)), 0L);
    }

    ConfigurableValueGraph(AbstractGraphBuilder<? super N> abstractGraphBuilder, Map<N, GraphConnections<N, V>> map, long l2) {
        this.isDirected = abstractGraphBuilder.directed;
        this.allowsSelfLoops = abstractGraphBuilder.allowsSelfLoops;
        this.nodeOrder = abstractGraphBuilder.nodeOrder.cast();
        this.nodeConnections = map instanceof TreeMap ? new MapRetrievalCache<N, GraphConnections<N, V>>(map) : new MapIteratorCache<N, GraphConnections<N, V>>(map);
        this.edgeCount = Graphs.checkNonNegative(l2);
    }

    @Override
    public Set<N> nodes() {
        return this.nodeConnections.unmodifiableKeySet();
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.allowsSelfLoops;
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.nodeOrder;
    }

    @Override
    public Set<N> adjacentNodes(N n2) {
        return this.checkedConnections(n2).adjacentNodes();
    }

    @Override
    public Set<N> predecessors(N n2) {
        return this.checkedConnections(n2).predecessors();
    }

    @Override
    public Set<N> successors(N n2) {
        return this.checkedConnections(n2).successors();
    }

    @Override
    public boolean hasEdgeConnecting(N n2, N n3) {
        return this.hasEdgeConnecting_internal(Preconditions.checkNotNull(n2), Preconditions.checkNotNull(n3));
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
        Preconditions.checkNotNull(endpointPair);
        return this.isOrderingCompatible(endpointPair) && this.hasEdgeConnecting_internal(endpointPair.nodeU(), endpointPair.nodeV());
    }

    @Override
    public @Nullable V edgeValueOrDefault(N n2, N n3, @Nullable V v2) {
        return this.edgeValueOrDefault_internal(Preconditions.checkNotNull(n2), Preconditions.checkNotNull(n3), v2);
    }

    @Override
    public @Nullable V edgeValueOrDefault(EndpointPair<N> endpointPair, @Nullable V v2) {
        this.validateEndpoints(endpointPair);
        return this.edgeValueOrDefault_internal(endpointPair.nodeU(), endpointPair.nodeV(), v2);
    }

    @Override
    protected long edgeCount() {
        return this.edgeCount;
    }

    protected final GraphConnections<N, V> checkedConnections(N n2) {
        GraphConnections<N, V> graphConnections = this.nodeConnections.get(n2);
        if (graphConnections == null) {
            Preconditions.checkNotNull(n2);
            throw new IllegalArgumentException("Node " + n2 + " is not an element of this graph.");
        }
        return graphConnections;
    }

    protected final boolean containsNode(@Nullable N n2) {
        return this.nodeConnections.containsKey(n2);
    }

    protected final boolean hasEdgeConnecting_internal(N n2, N n3) {
        GraphConnections<N, V> graphConnections = this.nodeConnections.get(n2);
        return graphConnections != null && graphConnections.successors().contains(n3);
    }

    protected final V edgeValueOrDefault_internal(N n2, N n3, V v2) {
        GraphConnections<N, V> graphConnections = this.nodeConnections.get(n2);
        Object var5_5 = graphConnections == null ? null : graphConnections.value(n3);
        return (V)(var5_5 == null ? v2 : var5_5);
    }
}

