/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.AbstractNetwork;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.MapIteratorCache;
import com.google.common.graph.MapRetrievalCache;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NetworkConnections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.qual.Nullable;

class ConfigurableNetwork<N, E>
extends AbstractNetwork<N, E> {
    private final boolean isDirected;
    private final boolean allowsParallelEdges;
    private final boolean allowsSelfLoops;
    private final ElementOrder<N> nodeOrder;
    private final ElementOrder<E> edgeOrder;
    protected final MapIteratorCache<N, NetworkConnections<N, E>> nodeConnections;
    protected final MapIteratorCache<E, N> edgeToReferenceNode;

    ConfigurableNetwork(NetworkBuilder<? super N, ? super E> networkBuilder) {
        this(networkBuilder, networkBuilder.nodeOrder.createMap(networkBuilder.expectedNodeCount.or(10)), networkBuilder.edgeOrder.createMap(networkBuilder.expectedEdgeCount.or(20)));
    }

    ConfigurableNetwork(NetworkBuilder<? super N, ? super E> networkBuilder, Map<N, NetworkConnections<N, E>> map, Map<E, N> map2) {
        this.isDirected = networkBuilder.directed;
        this.allowsParallelEdges = networkBuilder.allowsParallelEdges;
        this.allowsSelfLoops = networkBuilder.allowsSelfLoops;
        this.nodeOrder = networkBuilder.nodeOrder.cast();
        this.edgeOrder = networkBuilder.edgeOrder.cast();
        this.nodeConnections = map instanceof TreeMap ? new MapRetrievalCache<N, NetworkConnections<N, E>>(map) : new MapIteratorCache<N, NetworkConnections<N, E>>(map);
        this.edgeToReferenceNode = new MapIteratorCache<E, N>(map2);
    }

    @Override
    public Set<N> nodes() {
        return this.nodeConnections.unmodifiableKeySet();
    }

    @Override
    public Set<E> edges() {
        return this.edgeToReferenceNode.unmodifiableKeySet();
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public boolean allowsParallelEdges() {
        return this.allowsParallelEdges;
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.allowsSelfLoops;
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.nodeOrder;
    }

    @Override
    public ElementOrder<E> edgeOrder() {
        return this.edgeOrder;
    }

    @Override
    public Set<E> incidentEdges(N n2) {
        return this.checkedConnections(n2).incidentEdges();
    }

    @Override
    public EndpointPair<N> incidentNodes(E e2) {
        N n2 = this.checkedReferenceNode(e2);
        N n3 = this.nodeConnections.get(n2).adjacentNode(e2);
        return EndpointPair.of(this, n2, n3);
    }

    @Override
    public Set<N> adjacentNodes(N n2) {
        return this.checkedConnections(n2).adjacentNodes();
    }

    @Override
    public Set<E> edgesConnecting(N n2, N n3) {
        NetworkConnections<N, E> networkConnections = this.checkedConnections(n2);
        if (!this.allowsSelfLoops && n2 == n3) {
            return ImmutableSet.of();
        }
        Preconditions.checkArgument(this.containsNode(n3), "Node %s is not an element of this graph.", n3);
        return networkConnections.edgesConnecting(n3);
    }

    @Override
    public Set<E> inEdges(N n2) {
        return this.checkedConnections(n2).inEdges();
    }

    @Override
    public Set<E> outEdges(N n2) {
        return this.checkedConnections(n2).outEdges();
    }

    @Override
    public Set<N> predecessors(N n2) {
        return this.checkedConnections(n2).predecessors();
    }

    @Override
    public Set<N> successors(N n2) {
        return this.checkedConnections(n2).successors();
    }

    protected final NetworkConnections<N, E> checkedConnections(N n2) {
        NetworkConnections<N, E> networkConnections = this.nodeConnections.get(n2);
        if (networkConnections == null) {
            Preconditions.checkNotNull(n2);
            throw new IllegalArgumentException(String.format("Node %s is not an element of this graph.", n2));
        }
        return networkConnections;
    }

    protected final N checkedReferenceNode(E e2) {
        N n2 = this.edgeToReferenceNode.get(e2);
        if (n2 == null) {
            Preconditions.checkNotNull(e2);
            throw new IllegalArgumentException(String.format("Edge %s is not an element of this graph.", e2));
        }
        return n2;
    }

    protected final boolean containsNode(@Nullable N n2) {
        return this.nodeConnections.containsKey(n2);
    }

    protected final boolean containsEdge(@Nullable E e2) {
        return this.edgeToReferenceNode.containsKey(e2);
    }
}

