/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.AbstractGraphBuilder;
import com.google.common.graph.ConfigurableValueGraph;
import com.google.common.graph.DirectedGraphConnections;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.UndirectedGraphConnections;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

final class ConfigurableMutableValueGraph<N, V>
extends ConfigurableValueGraph<N, V>
implements MutableValueGraph<N, V> {
    ConfigurableMutableValueGraph(AbstractGraphBuilder<? super N> abstractGraphBuilder) {
        super(abstractGraphBuilder);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addNode(N n2) {
        Preconditions.checkNotNull(n2, "node");
        if (this.containsNode(n2)) {
            return false;
        }
        this.addNodeInternal(n2);
        return true;
    }

    @CanIgnoreReturnValue
    private GraphConnections<N, V> addNodeInternal(N n2) {
        GraphConnections<N, V> graphConnections = this.newConnections();
        Preconditions.checkState(this.nodeConnections.put(n2, graphConnections) == null);
        return graphConnections;
    }

    @Override
    @CanIgnoreReturnValue
    public V putEdgeValue(N n2, N n3, V v2) {
        GraphConnections<N, V> graphConnections;
        Preconditions.checkNotNull(n2, "nodeU");
        Preconditions.checkNotNull(n3, "nodeV");
        Preconditions.checkNotNull(v2, "value");
        if (!this.allowsSelfLoops()) {
            Preconditions.checkArgument(!n2.equals(n3), "Cannot add self-loop edge on node %s, as self-loops are not allowed. To construct a graph that allows self-loops, call allowsSelfLoops(true) on the Builder.", n2);
        }
        if ((graphConnections = (GraphConnections<N, V>)this.nodeConnections.get(n2)) == null) {
            graphConnections = this.addNodeInternal(n2);
        }
        V v3 = graphConnections.addSuccessor(n3, v2);
        GraphConnections<N, V> graphConnections2 = (GraphConnections<N, V>)this.nodeConnections.get(n3);
        if (graphConnections2 == null) {
            graphConnections2 = this.addNodeInternal(n3);
        }
        graphConnections2.addPredecessor(n2, v2);
        if (v3 == null) {
            Graphs.checkPositive(++this.edgeCount);
        }
        return v3;
    }

    @Override
    @CanIgnoreReturnValue
    public V putEdgeValue(EndpointPair<N> endpointPair, V v2) {
        this.validateEndpoints(endpointPair);
        return this.putEdgeValue(endpointPair.nodeU(), endpointPair.nodeV(), v2);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeNode(N n2) {
        Preconditions.checkNotNull(n2, "node");
        GraphConnections graphConnections = (GraphConnections)this.nodeConnections.get(n2);
        if (graphConnections == null) {
            return false;
        }
        if (this.allowsSelfLoops() && graphConnections.removeSuccessor(n2) != null) {
            graphConnections.removePredecessor(n2);
            --this.edgeCount;
        }
        for (Object n3 : graphConnections.successors()) {
            ((GraphConnections)this.nodeConnections.getWithoutCaching(n3)).removePredecessor(n2);
            --this.edgeCount;
        }
        if (this.isDirected()) {
            for (Object n3 : graphConnections.predecessors()) {
                Preconditions.checkState(((GraphConnections)this.nodeConnections.getWithoutCaching(n3)).removeSuccessor(n2) != null);
                --this.edgeCount;
            }
        }
        this.nodeConnections.remove(n2);
        Graphs.checkNonNegative(this.edgeCount);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public V removeEdge(N n2, N n3) {
        Preconditions.checkNotNull(n2, "nodeU");
        Preconditions.checkNotNull(n3, "nodeV");
        GraphConnections graphConnections = (GraphConnections)this.nodeConnections.get(n2);
        GraphConnections graphConnections2 = (GraphConnections)this.nodeConnections.get(n3);
        if (graphConnections == null || graphConnections2 == null) {
            return null;
        }
        Object v2 = graphConnections.removeSuccessor(n3);
        if (v2 != null) {
            graphConnections2.removePredecessor(n2);
            Graphs.checkNonNegative(--this.edgeCount);
        }
        return v2;
    }

    @Override
    @CanIgnoreReturnValue
    public V removeEdge(EndpointPair<N> endpointPair) {
        this.validateEndpoints(endpointPair);
        return this.removeEdge(endpointPair.nodeU(), endpointPair.nodeV());
    }

    private GraphConnections<N, V> newConnections() {
        return this.isDirected() ? DirectedGraphConnections.of() : UndirectedGraphConnections.of();
    }
}

