/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.ConfigurableNetwork;
import com.google.common.graph.DirectedMultiNetworkConnections;
import com.google.common.graph.DirectedNetworkConnections;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NetworkConnections;
import com.google.common.graph.UndirectedMultiNetworkConnections;
import com.google.common.graph.UndirectedNetworkConnections;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

final class ConfigurableMutableNetwork<N, E>
extends ConfigurableNetwork<N, E>
implements MutableNetwork<N, E> {
    ConfigurableMutableNetwork(NetworkBuilder<? super N, ? super E> networkBuilder) {
        super(networkBuilder);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addNode(N n2) {
        Preconditions.checkNotNull(n2, "node");
        if (this.containsNode(n2)) {
            return false;
        }
        this.addNodeInternal(n2);
        return true;
    }

    @CanIgnoreReturnValue
    private NetworkConnections<N, E> addNodeInternal(N n2) {
        NetworkConnections<N, E> networkConnections = this.newConnections();
        Preconditions.checkState(this.nodeConnections.put(n2, networkConnections) == null);
        return networkConnections;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addEdge(N n2, N n3, E e2) {
        Preconditions.checkNotNull(n2, "nodeU");
        Preconditions.checkNotNull(n3, "nodeV");
        Preconditions.checkNotNull(e2, "edge");
        if (this.containsEdge(e2)) {
            EndpointPair endpointPair = this.incidentNodes(e2);
            EndpointPair<N> endpointPair2 = EndpointPair.of(this, n2, n3);
            Preconditions.checkArgument(endpointPair.equals(endpointPair2), "Edge %s already exists between the following nodes: %s, so it cannot be reused to connect the following nodes: %s.", e2, endpointPair, endpointPair2);
            return false;
        }
        NetworkConnections<N, E> networkConnections = (NetworkConnections<N, E>)this.nodeConnections.get(n2);
        if (!this.allowsParallelEdges()) {
            Preconditions.checkArgument(networkConnections == null || !networkConnections.successors().contains(n3), "Nodes %s and %s are already connected by a different edge. To construct a graph that allows parallel edges, call allowsParallelEdges(true) on the Builder.", n2, n3);
        }
        boolean bl2 = n2.equals(n3);
        if (!this.allowsSelfLoops()) {
            Preconditions.checkArgument(!bl2, "Cannot add self-loop edge on node %s, as self-loops are not allowed. To construct a graph that allows self-loops, call allowsSelfLoops(true) on the Builder.", n2);
        }
        if (networkConnections == null) {
            networkConnections = this.addNodeInternal(n2);
        }
        networkConnections.addOutEdge(e2, n3);
        NetworkConnections<N, E> networkConnections2 = (NetworkConnections<N, E>)this.nodeConnections.get(n3);
        if (networkConnections2 == null) {
            networkConnections2 = this.addNodeInternal(n3);
        }
        networkConnections2.addInEdge(e2, n2, bl2);
        this.edgeToReferenceNode.put(e2, n2);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addEdge(EndpointPair<N> endpointPair, E e2) {
        this.validateEndpoints(endpointPair);
        return this.addEdge(endpointPair.nodeU(), endpointPair.nodeV(), e2);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeNode(N n2) {
        Preconditions.checkNotNull(n2, "node");
        NetworkConnections networkConnections = (NetworkConnections)this.nodeConnections.get(n2);
        if (networkConnections == null) {
            return false;
        }
        for (Object e2 : ImmutableList.copyOf(networkConnections.incidentEdges())) {
            this.removeEdge(e2);
        }
        this.nodeConnections.remove(n2);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeEdge(E e2) {
        Preconditions.checkNotNull(e2, "edge");
        Object v2 = this.edgeToReferenceNode.get(e2);
        if (v2 == null) {
            return false;
        }
        NetworkConnections networkConnections = (NetworkConnections)this.nodeConnections.get(v2);
        Object n2 = networkConnections.adjacentNode(e2);
        NetworkConnections networkConnections2 = (NetworkConnections)this.nodeConnections.get(n2);
        networkConnections.removeOutEdge(e2);
        networkConnections2.removeInEdge(e2, this.allowsSelfLoops() && v2.equals(n2));
        this.edgeToReferenceNode.remove(e2);
        return true;
    }

    private NetworkConnections<N, E> newConnections() {
        return this.isDirected() ? (this.allowsParallelEdges() ? DirectedMultiNetworkConnections.of() : DirectedNetworkConnections.of()) : (this.allowsParallelEdges() ? UndirectedMultiNetworkConnections.of() : UndirectedNetworkConnections.of());
    }
}

