/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.NetworkConnections;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

abstract class AbstractUndirectedNetworkConnections<N, E>
implements NetworkConnections<N, E> {
    protected final Map<E, N> incidentEdgeMap;

    protected AbstractUndirectedNetworkConnections(Map<E, N> map) {
        this.incidentEdgeMap = Preconditions.checkNotNull(map);
    }

    @Override
    public Set<N> predecessors() {
        return this.adjacentNodes();
    }

    @Override
    public Set<N> successors() {
        return this.adjacentNodes();
    }

    @Override
    public Set<E> incidentEdges() {
        return Collections.unmodifiableSet(this.incidentEdgeMap.keySet());
    }

    @Override
    public Set<E> inEdges() {
        return this.incidentEdges();
    }

    @Override
    public Set<E> outEdges() {
        return this.incidentEdges();
    }

    @Override
    public N adjacentNode(E e2) {
        return Preconditions.checkNotNull(this.incidentEdgeMap.get(e2));
    }

    @Override
    public N removeInEdge(E e2, boolean bl2) {
        if (!bl2) {
            return this.removeOutEdge(e2);
        }
        return null;
    }

    @Override
    public N removeOutEdge(E e2) {
        N n2 = this.incidentEdgeMap.remove(e2);
        return Preconditions.checkNotNull(n2);
    }

    @Override
    public void addInEdge(E e2, N n2, boolean bl2) {
        if (!bl2) {
            this.addOutEdge(e2, n2);
        }
    }

    @Override
    public void addOutEdge(E e2, N n2) {
        N n3 = this.incidentEdgeMap.put(e2, n2);
        Preconditions.checkState(n3 == null);
    }
}

