/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.AbstractGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Network;
import com.google.common.math.IntMath;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
public abstract class AbstractNetwork<N, E>
implements Network<N, E> {
    @Override
    public Graph<N> asGraph() {
        return new AbstractGraph<N>(){

            @Override
            public Set<N> nodes() {
                return AbstractNetwork.this.nodes();
            }

            @Override
            public Set<EndpointPair<N>> edges() {
                if (AbstractNetwork.this.allowsParallelEdges()) {
                    return super.edges();
                }
                return new AbstractSet<EndpointPair<N>>(){

                    @Override
                    public Iterator<EndpointPair<N>> iterator() {
                        return Iterators.transform(AbstractNetwork.this.edges().iterator(), new Function<E, EndpointPair<N>>(){

                            @Override
                            public EndpointPair<N> apply(E e2) {
                                return AbstractNetwork.this.incidentNodes(e2);
                            }
                        });
                    }

                    @Override
                    public int size() {
                        return AbstractNetwork.this.edges().size();
                    }

                    @Override
                    public boolean contains(@Nullable Object object) {
                        if (!(object instanceof EndpointPair)) {
                            return false;
                        }
                        EndpointPair endpointPair = (EndpointPair)object;
                        return this.isOrderingCompatible(endpointPair) && this.nodes().contains(endpointPair.nodeU()) && this.successors(endpointPair.nodeU()).contains(endpointPair.nodeV());
                    }
                };
            }

            @Override
            public ElementOrder<N> nodeOrder() {
                return AbstractNetwork.this.nodeOrder();
            }

            @Override
            public boolean isDirected() {
                return AbstractNetwork.this.isDirected();
            }

            @Override
            public boolean allowsSelfLoops() {
                return AbstractNetwork.this.allowsSelfLoops();
            }

            @Override
            public Set<N> adjacentNodes(N n2) {
                return AbstractNetwork.this.adjacentNodes(n2);
            }

            @Override
            public Set<N> predecessors(N n2) {
                return AbstractNetwork.this.predecessors(n2);
            }

            @Override
            public Set<N> successors(N n2) {
                return AbstractNetwork.this.successors(n2);
            }
        };
    }

    @Override
    public int degree(N n2) {
        if (this.isDirected()) {
            return IntMath.saturatedAdd(this.inEdges(n2).size(), this.outEdges(n2).size());
        }
        return IntMath.saturatedAdd(this.incidentEdges(n2).size(), this.edgesConnecting(n2, n2).size());
    }

    @Override
    public int inDegree(N n2) {
        return this.isDirected() ? this.inEdges(n2).size() : this.degree(n2);
    }

    @Override
    public int outDegree(N n2) {
        return this.isDirected() ? this.outEdges(n2).size() : this.degree(n2);
    }

    @Override
    public Set<E> adjacentEdges(E e2) {
        EndpointPair endpointPair = this.incidentNodes(e2);
        Sets.SetView setView = Sets.union(this.incidentEdges(endpointPair.nodeU()), this.incidentEdges(endpointPair.nodeV()));
        return Sets.difference(setView, ImmutableSet.of(e2));
    }

    @Override
    public Set<E> edgesConnecting(N n2, N n3) {
        Set set = this.outEdges(n2);
        Set set2 = this.inEdges(n3);
        return set.size() <= set2.size() ? Collections.unmodifiableSet(Sets.filter(set, this.connectedPredicate(n2, n3))) : Collections.unmodifiableSet(Sets.filter(set2, this.connectedPredicate(n3, n2)));
    }

    @Override
    public Set<E> edgesConnecting(EndpointPair<N> endpointPair) {
        this.validateEndpoints(endpointPair);
        return this.edgesConnecting(endpointPair.nodeU(), endpointPair.nodeV());
    }

    private Predicate<E> connectedPredicate(final N n2, final N n3) {
        return new Predicate<E>(){

            @Override
            public boolean apply(E e2) {
                return AbstractNetwork.this.incidentNodes(e2).adjacentNode(n2).equals(n3);
            }
        };
    }

    @Override
    public Optional<E> edgeConnecting(N n2, N n3) {
        return Optional.ofNullable(this.edgeConnectingOrNull(n2, n3));
    }

    @Override
    public Optional<E> edgeConnecting(EndpointPair<N> endpointPair) {
        this.validateEndpoints(endpointPair);
        return this.edgeConnecting(endpointPair.nodeU(), endpointPair.nodeV());
    }

    @Override
    public @Nullable E edgeConnectingOrNull(N n2, N n3) {
        Set<E> set = this.edgesConnecting(n2, n3);
        switch (set.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return set.iterator().next();
            }
        }
        throw new IllegalArgumentException(String.format("Cannot call edgeConnecting() when parallel edges exist between %s and %s. Consider calling edgesConnecting() instead.", n2, n3));
    }

    @Override
    public @Nullable E edgeConnectingOrNull(EndpointPair<N> endpointPair) {
        this.validateEndpoints(endpointPair);
        return this.edgeConnectingOrNull(endpointPair.nodeU(), endpointPair.nodeV());
    }

    @Override
    public boolean hasEdgeConnecting(N n2, N n3) {
        return !this.edgesConnecting(n2, n3).isEmpty();
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
        Preconditions.checkNotNull(endpointPair);
        if (!this.isOrderingCompatible(endpointPair)) {
            return false;
        }
        return !this.edgesConnecting(endpointPair.nodeU(), endpointPair.nodeV()).isEmpty();
    }

    protected final void validateEndpoints(EndpointPair<?> endpointPair) {
        Preconditions.checkNotNull(endpointPair);
        Preconditions.checkArgument(this.isOrderingCompatible(endpointPair), "Mismatch: unordered endpoints cannot be used with directed graphs");
    }

    protected final boolean isOrderingCompatible(EndpointPair<?> endpointPair) {
        return endpointPair.isOrdered() || !this.isDirected();
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Network)) {
            return false;
        }
        Network network = (Network)object;
        return this.isDirected() == network.isDirected() && this.nodes().equals(network.nodes()) && AbstractNetwork.edgeIncidentNodesMap(this).equals(AbstractNetwork.edgeIncidentNodesMap(network));
    }

    @Override
    public final int hashCode() {
        return AbstractNetwork.edgeIncidentNodesMap(this).hashCode();
    }

    public String toString() {
        return "isDirected: " + this.isDirected() + ", allowsParallelEdges: " + this.allowsParallelEdges() + ", allowsSelfLoops: " + this.allowsSelfLoops() + ", nodes: " + this.nodes() + ", edges: " + AbstractNetwork.edgeIncidentNodesMap(this);
    }

    private static <N, E> Map<E, EndpointPair<N>> edgeIncidentNodesMap(final Network<N, E> network) {
        Function function = new Function<E, EndpointPair<N>>(){

            @Override
            public EndpointPair<N> apply(E e2) {
                return network.incidentNodes(e2);
            }
        };
        return Maps.asMap(network.edges(), function);
    }
}

