/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.EndpointPairIterator;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import java.util.AbstractSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractBaseGraph<N>
implements BaseGraph<N> {
    AbstractBaseGraph() {
    }

    protected long edgeCount() {
        long l2 = 0L;
        for (Object n2 : this.nodes()) {
            l2 += (long)this.degree(n2);
        }
        Preconditions.checkState((l2 & 1L) == 0L);
        return l2 >>> 1;
    }

    @Override
    public Set<EndpointPair<N>> edges() {
        return new AbstractSet<EndpointPair<N>>(){

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                return EndpointPairIterator.of(AbstractBaseGraph.this);
            }

            @Override
            public int size() {
                return Ints.saturatedCast(AbstractBaseGraph.this.edgeCount());
            }

            @Override
            public boolean remove(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean contains(@Nullable Object object) {
                if (!(object instanceof EndpointPair)) {
                    return false;
                }
                EndpointPair endpointPair = (EndpointPair)object;
                return AbstractBaseGraph.this.isOrderingCompatible(endpointPair) && AbstractBaseGraph.this.nodes().contains(endpointPair.nodeU()) && AbstractBaseGraph.this.successors(endpointPair.nodeU()).contains(endpointPair.nodeV());
            }
        };
    }

    @Override
    public Set<EndpointPair<N>> incidentEdges(N n2) {
        Preconditions.checkNotNull(n2);
        Preconditions.checkArgument(this.nodes().contains(n2), "Node %s is not an element of this graph.", n2);
        return IncidentEdgeSet.of(this, n2);
    }

    @Override
    public int degree(N n2) {
        if (this.isDirected()) {
            return IntMath.saturatedAdd(this.predecessors((Object)n2).size(), this.successors((Object)n2).size());
        }
        Set<N> set = this.adjacentNodes(n2);
        int n3 = this.allowsSelfLoops() && set.contains(n2) ? 1 : 0;
        return IntMath.saturatedAdd(set.size(), n3);
    }

    @Override
    public int inDegree(N n2) {
        return this.isDirected() ? this.predecessors((Object)n2).size() : this.degree(n2);
    }

    @Override
    public int outDegree(N n2) {
        return this.isDirected() ? this.successors((Object)n2).size() : this.degree(n2);
    }

    @Override
    public boolean hasEdgeConnecting(N n2, N n3) {
        Preconditions.checkNotNull(n2);
        Preconditions.checkNotNull(n3);
        return this.nodes().contains(n2) && this.successors((Object)n2).contains(n3);
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
        Preconditions.checkNotNull(endpointPair);
        if (!this.isOrderingCompatible(endpointPair)) {
            return false;
        }
        N n2 = endpointPair.nodeU();
        N n3 = endpointPair.nodeV();
        return this.nodes().contains(n2) && this.successors((Object)n2).contains(n3);
    }

    protected final void validateEndpoints(EndpointPair<?> endpointPair) {
        Preconditions.checkNotNull(endpointPair);
        Preconditions.checkArgument(this.isOrderingCompatible(endpointPair), "Mismatch: unordered endpoints cannot be used with directed graphs");
    }

    protected final boolean isOrderingCompatible(EndpointPair<?> endpointPair) {
        return endpointPair.isOrdered() || !this.isDirected();
    }

    private static abstract class IncidentEdgeSet<N>
    extends AbstractSet<EndpointPair<N>> {
        protected final N node;
        protected final BaseGraph<N> graph;

        public static <N> IncidentEdgeSet<N> of(BaseGraph<N> baseGraph, N n2) {
            return baseGraph.isDirected() ? new Directed(baseGraph, n2) : new Undirected(baseGraph, n2);
        }

        private IncidentEdgeSet(BaseGraph<N> baseGraph, N n2) {
            this.graph = baseGraph;
            this.node = n2;
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        private static final class Undirected<N>
        extends IncidentEdgeSet<N> {
            private Undirected(BaseGraph<N> baseGraph, N n2) {
                super(baseGraph, n2);
            }

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                return Iterators.unmodifiableIterator(Iterators.transform(this.graph.adjacentNodes(this.node).iterator(), new Function<N, EndpointPair<N>>(){

                    @Override
                    public EndpointPair<N> apply(N n2) {
                        return EndpointPair.unordered(node, n2);
                    }
                }));
            }

            @Override
            public int size() {
                return this.graph.adjacentNodes(this.node).size();
            }

            @Override
            public boolean contains(@Nullable Object object) {
                if (!(object instanceof EndpointPair)) {
                    return false;
                }
                EndpointPair endpointPair = (EndpointPair)object;
                if (endpointPair.isOrdered()) {
                    return false;
                }
                Set<Object> set = this.graph.adjacentNodes(this.node);
                Object n2 = endpointPair.nodeU();
                Object n3 = endpointPair.nodeV();
                return this.node.equals(n3) && set.contains(n2) || this.node.equals(n2) && set.contains(n3);
            }
        }

        private static final class Directed<N>
        extends IncidentEdgeSet<N> {
            private Directed(BaseGraph<N> baseGraph, N n2) {
                super(baseGraph, n2);
            }

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                return Iterators.unmodifiableIterator(Iterators.concat(Iterators.transform(this.graph.predecessors(this.node).iterator(), new Function<N, EndpointPair<N>>(){

                    @Override
                    public EndpointPair<N> apply(N n2) {
                        return EndpointPair.ordered(n2, node);
                    }
                }), Iterators.transform(Sets.difference(this.graph.successors(this.node), ImmutableSet.of(this.node)).iterator(), new Function<N, EndpointPair<N>>(){

                    @Override
                    public EndpointPair<N> apply(N n2) {
                        return EndpointPair.ordered(node, n2);
                    }
                })));
            }

            @Override
            public int size() {
                return this.graph.inDegree(this.node) + this.graph.outDegree(this.node) - (this.graph.successors(this.node).contains(this.node) ? 1 : 0);
            }

            @Override
            public boolean contains(@Nullable Object object) {
                if (!(object instanceof EndpointPair)) {
                    return false;
                }
                EndpointPair endpointPair = (EndpointPair)object;
                if (!endpointPair.isOrdered()) {
                    return false;
                }
                Object n2 = endpointPair.source();
                Object n3 = endpointPair.target();
                return this.node.equals(n2) && this.graph.successors(this.node).contains(n3) || this.node.equals(n3) && this.graph.predecessors(this.node).contains(n2);
            }
        }
    }
}

