/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.util;

import com.google.common.flogger.LogSite;
import com.google.common.flogger.util.Checks;
import com.google.errorprone.annotations.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
public final class StackBasedLogSite
extends LogSite {
    private final StackTraceElement stackElement;

    public StackBasedLogSite(StackTraceElement stackTraceElement) {
        this.stackElement = Checks.checkNotNull(stackTraceElement, "stack element");
    }

    @Override
    public String getClassName() {
        return this.stackElement.getClassName();
    }

    @Override
    public String getMethodName() {
        return this.stackElement.getMethodName();
    }

    @Override
    public int getLineNumber() {
        return Math.max(this.stackElement.getLineNumber(), 0);
    }

    @Override
    public String getFileName() {
        return this.stackElement.getFileName();
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof StackBasedLogSite && this.stackElement.equals(((StackBasedLogSite)object).stackElement);
    }

    public int hashCode() {
        return this.stackElement.hashCode();
    }
}

