/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.util;

import com.google.errorprone.annotations.CheckReturnValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

@CheckReturnValue
final class FastStackGetter {
    private final Object javaLangAccess;
    private final Method getElementMethod;
    private final Method getDepthMethod;

    @Nullable
    public static FastStackGetter createIfSupported() {
        try {
            Object object = Class.forName("sun.misc.SharedSecrets").getMethod("getJavaLangAccess", new Class[0]).invoke(null, new Object[0]);
            Method method = Class.forName("sun.misc.JavaLangAccess").getMethod("getStackTraceElement", Throwable.class, Integer.TYPE);
            Method method2 = Class.forName("sun.misc.JavaLangAccess").getMethod("getStackTraceDepth", Throwable.class);
            StackTraceElement stackTraceElement = (StackTraceElement)method.invoke(object, new Throwable(), 0);
            int n2 = (Integer)method2.invoke(object, new Throwable());
            return new FastStackGetter(object, method, method2);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private FastStackGetter(Object object, Method method, Method method2) {
        this.javaLangAccess = object;
        this.getElementMethod = method;
        this.getDepthMethod = method2;
    }

    public StackTraceElement getStackTraceElement(Throwable throwable, int n2) {
        try {
            return (StackTraceElement)this.getElementMethod.invoke(this.javaLangAccess, throwable, n2);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            if (invocationTargetException.getCause() instanceof Error) {
                throw (Error)invocationTargetException.getCause();
            }
            throw new RuntimeException(invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    public int getStackTraceDepth(Throwable throwable) {
        try {
            return (Integer)this.getDepthMethod.invoke(this.javaLangAccess, throwable);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            if (invocationTargetException.getCause() instanceof Error) {
                throw (Error)invocationTargetException.getCause();
            }
            throw new RuntimeException(invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }
}

