/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.util;

public class Checks {
    private Checks() {
    }

    public static <T> T checkNotNull(T t2, String string) {
        if (t2 == null) {
            throw new NullPointerException(string + " must not be null");
        }
        return t2;
    }

    public static void checkArgument(boolean bl2, String string) {
        if (!bl2) {
            throw new IllegalArgumentException(string);
        }
    }

    public static String checkMetadataIdentifier(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("identifier must not be empty");
        }
        if (!Checks.isLetter(string.charAt(0))) {
            throw new IllegalArgumentException("identifier must start with an ASCII letter: " + string);
        }
        for (int i2 = 1; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Checks.isLetter(c2) || c2 >= '0' && c2 <= '9' || c2 == '_') continue;
            throw new IllegalArgumentException("identifier must contain only ASCII letters, digits or underscore: " + string);
        }
        return string;
    }

    private static boolean isLetter(char c2) {
        return 'a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z';
    }
}

