/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.util;

import com.google.common.flogger.util.Checks;
import com.google.common.flogger.util.FastStackGetter;
import com.google.errorprone.annotations.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
public final class CallerFinder {
    private static final FastStackGetter stackGetter = FastStackGetter.createIfSupported();

    @Nullable
    public static StackTraceElement findCallerOf(Class<?> clazz, Throwable throwable, int n2) {
        Checks.checkNotNull(clazz, "target");
        Checks.checkNotNull(throwable, "throwable");
        if (n2 < 0) {
            throw new IllegalArgumentException("skip count cannot be negative: " + n2);
        }
        StackTraceElement[] stackTraceElementArray = stackGetter != null ? null : throwable.getStackTrace();
        boolean bl2 = false;
        try {
            int n3 = n2;
            while (true) {
                StackTraceElement stackTraceElement;
                StackTraceElement stackTraceElement2 = stackTraceElement = stackGetter != null ? stackGetter.getStackTraceElement(throwable, n3) : stackTraceElementArray[n3];
                if (clazz.getName().equals(stackTraceElement.getClassName())) {
                    bl2 = true;
                } else if (bl2) {
                    return stackTraceElement;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static StackTraceElement[] getStackForCallerOf(Class<?> clazz, Throwable throwable, int n2) {
        int n3;
        StackTraceElement[] stackTraceElementArray;
        Checks.checkNotNull(clazz, "target");
        Checks.checkNotNull(throwable, "throwable");
        if (n2 <= 0 && n2 != -1) {
            throw new IllegalArgumentException("invalid maximum depth: " + n2);
        }
        if (stackGetter != null) {
            stackTraceElementArray = null;
            n3 = stackGetter.getStackTraceDepth(throwable);
        } else {
            stackTraceElementArray = throwable.getStackTrace();
            n3 = stackTraceElementArray.length;
        }
        boolean bl2 = false;
        for (int i2 = 0; i2 < n3; ++i2) {
            StackTraceElement stackTraceElement;
            StackTraceElement stackTraceElement2 = stackTraceElement = stackGetter != null ? stackGetter.getStackTraceElement(throwable, i2) : stackTraceElementArray[i2];
            if (clazz.getName().equals(stackTraceElement.getClassName())) {
                bl2 = true;
                continue;
            }
            if (!bl2) continue;
            int n4 = n3 - i2;
            if (n2 > 0 && n2 < n4) {
                n4 = n2;
            }
            StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[n4];
            stackTraceElementArray2[0] = stackTraceElement;
            for (int i3 = 1; i3 < n4; ++i3) {
                stackTraceElementArray2[i3] = stackGetter != null ? stackGetter.getStackTraceElement(throwable, i2 + i3) : stackTraceElementArray[i2 + i3];
            }
            return stackTraceElementArray2;
        }
        return new StackTraceElement[0];
    }
}

