/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.parser;

import com.google.common.flogger.parser.MessageBuilder;
import com.google.common.flogger.parser.MessageParser;
import com.google.common.flogger.parser.ParseException;

public abstract class PrintfMessageParser
extends MessageParser {
    private static final String ALLOWED_NEWLINE_PATTERN = "\\n|\\r(?:\\n)?";
    private static final String SYSTEM_NEWLINE = PrintfMessageParser.getSafeSystemNewline();

    static String getSafeSystemNewline() {
        try {
            String string = System.getProperty("line.separator");
            if (string.matches(ALLOWED_NEWLINE_PATTERN)) {
                return string;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return "\n";
    }

    abstract int parsePrintfTerm(MessageBuilder<?> var1, int var2, String var3, int var4, int var5, int var6);

    @Override
    public final void unescape(StringBuilder stringBuilder, String string, int n2, int n3) {
        PrintfMessageParser.unescapePrintf(stringBuilder, string, n2, n3);
    }

    @Override
    protected final <T> void parseImpl(MessageBuilder<T> messageBuilder) {
        String string = messageBuilder.getMessage();
        int n2 = -1;
        int n3 = 0;
        int n4 = PrintfMessageParser.nextPrintfTerm(string, 0);
        while (n4 >= 0) {
            char c2;
            int n5;
            int n6;
            int n7;
            int n8;
            block12: {
                n8 = n4++;
                n7 = n4;
                n6 = 0;
                while (n4 < string.length()) {
                    if ((n5 = (int)((c2 = string.charAt(n4++)) - 48)) < 10) {
                        if ((n6 = 10 * n6 + n5) < 1000000) continue;
                        throw ParseException.withBounds("index too large", string, n8, n4);
                    }
                    break block12;
                }
                throw ParseException.withStartPosition("unterminated parameter", string, n8);
            }
            if (c2 == '$') {
                n5 = n4 - 1 - n7;
                if (n5 == 0) {
                    throw ParseException.withBounds("missing index", string, n8, n4);
                }
                if (string.charAt(n7) == '0') {
                    throw ParseException.withBounds("index has leading zero", string, n8, n4);
                }
                --n6;
                n7 = n4;
                if (n4 == string.length()) {
                    throw ParseException.withStartPosition("unterminated parameter", string, n8);
                }
                c2 = string.charAt(n4++);
            } else if (c2 == '<') {
                if (n2 == -1) {
                    throw ParseException.withBounds("invalid relative parameter", string, n8, n4);
                }
                n6 = n2;
                n7 = n4;
                if (n4 == string.length()) {
                    throw ParseException.withStartPosition("unterminated parameter", string, n8);
                }
                c2 = string.charAt(n4++);
            } else {
                n6 = n3++;
            }
            n4 = PrintfMessageParser.findFormatChar(string, n8, n4 - 1);
            n4 = this.parsePrintfTerm(messageBuilder, n6, string, n8, n7, n4);
            n2 = n6;
            n4 = PrintfMessageParser.nextPrintfTerm(string, n4);
        }
    }

    static int nextPrintfTerm(String string, int n2) {
        while (n2 < string.length()) {
            if (string.charAt(n2++) != '%') continue;
            if (n2 < string.length()) {
                char c2 = string.charAt(n2);
                if (c2 == '%' || c2 == 'n') {
                    ++n2;
                    continue;
                }
                return n2 - 1;
            }
            throw ParseException.withStartPosition("trailing unquoted '%' character", string, n2 - 1);
        }
        return -1;
    }

    private static int findFormatChar(String string, int n2, int n3) {
        while (n3 < string.length()) {
            char c2 = string.charAt(n3);
            char c3 = (char)((c2 & 0xFFFFFFDF) - 65);
            if (c3 < '\u001a') {
                return n3;
            }
            ++n3;
        }
        throw ParseException.withStartPosition("unterminated parameter", string, n2);
    }

    static void unescapePrintf(StringBuilder stringBuilder, String string, int n2, int n3) {
        int n4 = n2;
        while (n4 < n3) {
            if (string.charAt(n4++) != '%') continue;
            if (n4 == n3) break;
            char c2 = string.charAt(n4);
            if (c2 == '%') {
                stringBuilder.append(string, n2, n4);
            } else {
                if (c2 != 'n') continue;
                stringBuilder.append(string, n2, n4 - 1);
                stringBuilder.append(SYSTEM_NEWLINE);
            }
            n2 = ++n4;
        }
        if (n2 < n3) {
            stringBuilder.append(string, n2, n3);
        }
    }
}

