/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.parser;

import com.google.common.flogger.backend.TemplateContext;
import com.google.common.flogger.parameter.Parameter;
import com.google.common.flogger.parser.MessageParser;
import com.google.common.flogger.parser.ParseException;
import com.google.common.flogger.util.Checks;

public abstract class MessageBuilder<T> {
    private final TemplateContext context;
    private int pmask = 0;
    private int maxIndex = -1;

    public MessageBuilder(TemplateContext templateContext) {
        this.context = Checks.checkNotNull(templateContext, "context");
    }

    public final MessageParser getParser() {
        return this.context.getParser();
    }

    public final String getMessage() {
        return this.context.getMessage();
    }

    public final int getExpectedArgumentCount() {
        return this.maxIndex + 1;
    }

    public final void addParameter(int n2, int n3, Parameter parameter) {
        if (parameter.getIndex() < 32) {
            this.pmask |= 1 << parameter.getIndex();
        }
        this.maxIndex = Math.max(this.maxIndex, parameter.getIndex());
        this.addParameterImpl(n2, n3, parameter);
    }

    protected abstract void addParameterImpl(int var1, int var2, Parameter var3);

    protected abstract T buildImpl();

    public final T build() {
        this.getParser().parseImpl(this);
        if ((this.pmask & this.pmask + 1) != 0 || this.maxIndex > 31 && this.pmask != -1) {
            int n2 = Integer.numberOfTrailingZeros(~this.pmask);
            throw ParseException.generic(String.format("unreferenced arguments [first missing index=%d]", n2), this.getMessage());
        }
        return this.buildImpl();
    }
}

