/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.parser;

import com.google.common.flogger.backend.FormatChar;
import com.google.common.flogger.backend.FormatOptions;
import com.google.common.flogger.parameter.DateTimeFormat;
import com.google.common.flogger.parameter.DateTimeParameter;
import com.google.common.flogger.parameter.Parameter;
import com.google.common.flogger.parameter.ParameterVisitor;
import com.google.common.flogger.parameter.SimpleParameter;
import com.google.common.flogger.parser.MessageBuilder;
import com.google.common.flogger.parser.ParseException;
import com.google.common.flogger.parser.PrintfMessageParser;

public class DefaultPrintfMessageParser
extends PrintfMessageParser {
    private static final PrintfMessageParser INSTANCE = new DefaultPrintfMessageParser();

    public static PrintfMessageParser getInstance() {
        return INSTANCE;
    }

    private DefaultPrintfMessageParser() {
    }

    @Override
    public int parsePrintfTerm(MessageBuilder<?> messageBuilder, int n2, String string, int n3, int n4, int n5) {
        Parameter parameter;
        int n6 = n5 + 1;
        char c2 = string.charAt(n5);
        boolean bl2 = (c2 & 0x20) == 0;
        FormatOptions formatOptions = FormatOptions.parse(string, n4, n5, bl2);
        FormatChar formatChar = FormatChar.of(c2);
        if (formatChar != null) {
            if (!formatOptions.areValidFor(formatChar)) {
                throw ParseException.withBounds("invalid format specifier", string, n3, n6);
            }
            parameter = SimpleParameter.of(n2, formatChar, formatOptions);
        } else if (c2 == 't' || c2 == 'T') {
            if (!formatOptions.validate(160, false)) {
                throw ParseException.withBounds("invalid format specification", string, n3, n6);
            }
            if (++n6 > string.length()) {
                throw ParseException.atPosition("truncated format specifier", string, n3);
            }
            DateTimeFormat dateTimeFormat = DateTimeFormat.of(string.charAt(n5 + 1));
            if (dateTimeFormat == null) {
                throw ParseException.atPosition("illegal date/time conversion", string, n5 + 1);
            }
            parameter = DateTimeParameter.of(dateTimeFormat, formatOptions, n2);
        } else if (c2 == 'h' || c2 == 'H') {
            if (!formatOptions.validate(160, false)) {
                throw ParseException.withBounds("invalid format specification", string, n3, n6);
            }
            parameter = DefaultPrintfMessageParser.wrapHexParameter(formatOptions, n2);
        } else {
            throw ParseException.withBounds("invalid format specification", string, n3, n5 + 1);
        }
        messageBuilder.addParameter(n3, n6, parameter);
        return n6;
    }

    private static Parameter wrapHexParameter(final FormatOptions formatOptions, int n2) {
        return new Parameter(formatOptions, n2){

            @Override
            protected void accept(ParameterVisitor parameterVisitor, Object object) {
                parameterVisitor.visit(object.hashCode(), FormatChar.HEX, this.getFormatOptions());
            }

            @Override
            public String getFormat() {
                return formatOptions.shouldUpperCase() ? "%H" : "%h";
            }
        };
    }
}

