/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.parser;

import com.google.common.flogger.parser.MessageBuilder;
import com.google.common.flogger.parser.MessageParser;
import com.google.common.flogger.parser.ParseException;

public abstract class BraceStyleMessageParser
extends MessageParser {
    private static final char BRACE_STYLE_SEPARATOR = ',';

    abstract void parseBraceFormatTerm(MessageBuilder<?> var1, int var2, String var3, int var4, int var5, int var6);

    @Override
    public final void unescape(StringBuilder stringBuilder, String string, int n2, int n3) {
        BraceStyleMessageParser.unescapeBraceFormat(stringBuilder, string, n2, n3);
    }

    @Override
    protected final <T> void parseImpl(MessageBuilder<T> messageBuilder) {
        String string = messageBuilder.getMessage();
        int n2 = BraceStyleMessageParser.nextBraceFormatTerm(string, 0);
        while (n2 >= 0) {
            int n3;
            char c2;
            int n4;
            int n5;
            int n6;
            int n7;
            block10: {
                n7 = n2++;
                n6 = n7 + 1;
                n5 = 0;
                while (n2 < string.length()) {
                    if ((n4 = (int)((c2 = string.charAt(n2++)) - 48)) < 10) {
                        if ((n5 = 10 * n5 + n4) < 1000000) continue;
                        throw ParseException.withBounds("index too large", string, n6, n2);
                    }
                    break block10;
                }
                throw ParseException.withStartPosition("unterminated parameter", string, n7);
            }
            n4 = n2 - 1 - n6;
            if (n4 == 0) {
                throw ParseException.withBounds("missing index", string, n7, n2);
            }
            if (string.charAt(n6) == '0' && n4 > 1) {
                throw ParseException.withBounds("index has leading zero", string, n6, n2 - 1);
            }
            if (c2 == '}') {
                n3 = -1;
            } else if (c2 == ',') {
                n3 = n2;
                do {
                    if (n2 != string.length()) continue;
                    throw ParseException.withStartPosition("unterminated parameter", string, n7);
                } while (string.charAt(n2++) != '}');
            } else {
                throw ParseException.withBounds("malformed index", string, n7 + 1, n2);
            }
            this.parseBraceFormatTerm(messageBuilder, n5, string, n7, n3, n2);
            n2 = BraceStyleMessageParser.nextBraceFormatTerm(string, n2);
        }
    }

    static int nextBraceFormatTerm(String string, int n2) {
        while (n2 < string.length()) {
            char c2;
            if ((c2 = string.charAt(n2++)) == '{') {
                return n2 - 1;
            }
            if (c2 != '\'') continue;
            if (n2 == string.length()) {
                throw ParseException.withStartPosition("trailing single quote", string, n2 - 1);
            }
            if (string.charAt(n2++) == '\'') continue;
            int n3 = n2 - 2;
            do {
                if (n2 != string.length()) continue;
                throw ParseException.withStartPosition("unmatched single quote", string, n3);
            } while (string.charAt(n2++) != '\'');
        }
        return -1;
    }

    static void unescapeBraceFormat(StringBuilder stringBuilder, String string, int n2, int n3) {
        int n4 = n2;
        boolean bl2 = false;
        while (n4 < n3) {
            char c2;
            if ((c2 = string.charAt(n4++)) != '\\' && c2 != '\'') continue;
            int n5 = n4 - 1;
            if (c2 == '\\' && (c2 = string.charAt(n4++)) != '\'') continue;
            stringBuilder.append(string, n2, n5);
            n2 = n4;
            if (n4 == n3) break;
            if (bl2) {
                bl2 = false;
                continue;
            }
            if (string.charAt(n4) != '\'') {
                bl2 = true;
                continue;
            }
            ++n4;
        }
        if (n2 < n3) {
            stringBuilder.append(string, n2, n3);
        }
    }
}

