/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.parameter;

import com.google.common.flogger.backend.FormatChar;
import com.google.common.flogger.backend.FormatOptions;
import com.google.common.flogger.parameter.Parameter;
import com.google.common.flogger.parameter.ParameterVisitor;
import com.google.common.flogger.util.Checks;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public final class SimpleParameter
extends Parameter {
    private static final int MAX_CACHED_PARAMETERS = 10;
    private static final Map<FormatChar, SimpleParameter[]> DEFAULT_PARAMETERS;
    private final FormatChar formatChar;
    private final String formatString;

    private static SimpleParameter[] createParameterArray(FormatChar formatChar) {
        SimpleParameter[] simpleParameterArray = new SimpleParameter[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            simpleParameterArray[i2] = new SimpleParameter(i2, formatChar, FormatOptions.getDefault());
        }
        return simpleParameterArray;
    }

    public static SimpleParameter of(int n2, FormatChar formatChar, FormatOptions formatOptions) {
        if (n2 < 10 && formatOptions.isDefault()) {
            return DEFAULT_PARAMETERS.get((Object)formatChar)[n2];
        }
        return new SimpleParameter(n2, formatChar, formatOptions);
    }

    private SimpleParameter(int n2, FormatChar formatChar, FormatOptions formatOptions) {
        super(formatOptions, n2);
        this.formatChar = Checks.checkNotNull(formatChar, "format char");
        this.formatString = formatOptions.isDefault() ? formatChar.getDefaultFormatString() : SimpleParameter.buildFormatString(formatOptions, formatChar);
    }

    static String buildFormatString(FormatOptions formatOptions, FormatChar formatChar) {
        char c2 = formatChar.getChar();
        c2 = formatOptions.shouldUpperCase() ? (char)(c2 & 0xFFFFFFDF) : c2;
        return formatOptions.appendPrintfOptions(new StringBuilder("%")).append(c2).toString();
    }

    @Override
    protected void accept(ParameterVisitor parameterVisitor, Object object) {
        parameterVisitor.visit(object, this.formatChar, this.getFormatOptions());
    }

    @Override
    public String getFormat() {
        return this.formatString;
    }

    static {
        EnumMap<FormatChar, SimpleParameter[]> enumMap = new EnumMap<FormatChar, SimpleParameter[]>(FormatChar.class);
        for (FormatChar formatChar : FormatChar.values()) {
            enumMap.put(formatChar, SimpleParameter.createParameterArray(formatChar));
        }
        DEFAULT_PARAMETERS = Collections.unmodifiableMap(enumMap);
    }
}

