/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.parameter;

import com.google.common.flogger.backend.FormatOptions;
import com.google.common.flogger.parameter.ParameterVisitor;

public abstract class Parameter {
    private final int index;
    private final FormatOptions options;

    protected Parameter(FormatOptions formatOptions, int n2) {
        if (formatOptions == null) {
            throw new IllegalArgumentException("format options cannot be null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid index: " + n2);
        }
        this.index = n2;
        this.options = formatOptions;
    }

    public final int getIndex() {
        return this.index;
    }

    protected final FormatOptions getFormatOptions() {
        return this.options;
    }

    public final void accept(ParameterVisitor parameterVisitor, Object[] objectArray) {
        if (this.getIndex() < objectArray.length) {
            Object object = objectArray[this.getIndex()];
            if (object != null) {
                this.accept(parameterVisitor, object);
            } else {
                parameterVisitor.visitNull();
            }
        } else {
            parameterVisitor.visitMissing();
        }
    }

    protected abstract void accept(ParameterVisitor var1, Object var2);

    public abstract String getFormat();
}

