/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.parameter;

import com.google.common.flogger.backend.FormatOptions;
import com.google.common.flogger.parameter.DateTimeFormat;
import com.google.common.flogger.parameter.Parameter;
import com.google.common.flogger.parameter.ParameterVisitor;

public final class DateTimeParameter
extends Parameter {
    private final DateTimeFormat format;
    private final String formatString;

    public static Parameter of(DateTimeFormat dateTimeFormat, FormatOptions formatOptions, int n2) {
        return new DateTimeParameter(formatOptions, n2, dateTimeFormat);
    }

    private DateTimeParameter(FormatOptions formatOptions, int n2, DateTimeFormat dateTimeFormat) {
        super(formatOptions, n2);
        this.format = dateTimeFormat;
        this.formatString = formatOptions.appendPrintfOptions(new StringBuilder("%")).append(formatOptions.shouldUpperCase() ? (char)'T' : 't').append(dateTimeFormat.getChar()).toString();
    }

    @Override
    protected void accept(ParameterVisitor parameterVisitor, Object object) {
        parameterVisitor.visitDateTime(object, this.format, this.getFormatOptions());
    }

    @Override
    public String getFormat() {
        return this.formatString;
    }
}

