/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.parameter;

import com.google.common.flogger.backend.FormatChar;
import com.google.common.flogger.backend.FormatOptions;
import com.google.common.flogger.backend.FormatType;
import com.google.common.flogger.parameter.DateTimeFormat;
import com.google.common.flogger.parameter.Parameter;
import com.google.common.flogger.parameter.ParameterVisitor;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class BraceStyleParameter
extends Parameter {
    private static final FormatOptions WITH_GROUPING = FormatOptions.of(16, -1, -1);
    private static final MessageFormat prototypeMessageFormatter = new MessageFormat("{0}", Locale.ROOT);
    private static final int MAX_CACHED_PARAMETERS = 10;
    private static final BraceStyleParameter[] DEFAULT_PARAMETERS = new BraceStyleParameter[10];

    public static BraceStyleParameter of(int n2) {
        return n2 < 10 ? DEFAULT_PARAMETERS[n2] : new BraceStyleParameter(n2);
    }

    private BraceStyleParameter(int n2) {
        super(FormatOptions.getDefault(), n2);
    }

    @Override
    protected void accept(ParameterVisitor parameterVisitor, Object object) {
        if (FormatType.INTEGRAL.canFormat(object)) {
            parameterVisitor.visit(object, FormatChar.DECIMAL, WITH_GROUPING);
        } else if (FormatType.FLOAT.canFormat(object)) {
            parameterVisitor.visit(object, FormatChar.FLOAT, WITH_GROUPING);
        } else if (object instanceof Date) {
            String string = ((MessageFormat)prototypeMessageFormatter.clone()).format(new Object[]{object}, new StringBuffer(), (FieldPosition)null).toString();
            parameterVisitor.visitPreformatted(object, string);
        } else if (object instanceof Calendar) {
            parameterVisitor.visitDateTime(object, DateTimeFormat.DATETIME_FULL, this.getFormatOptions());
        } else {
            parameterVisitor.visit(object, FormatChar.STRING, this.getFormatOptions());
        }
    }

    @Override
    public String getFormat() {
        return "%s";
    }

    static {
        for (int i2 = 0; i2 < 10; ++i2) {
            BraceStyleParameter.DEFAULT_PARAMETERS[i2] = new BraceStyleParameter(i2);
        }
    }
}

