/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend.system;

import com.google.common.flogger.AbstractLogger;
import com.google.common.flogger.LogSite;
import com.google.common.flogger.backend.Platform;
import com.google.common.flogger.util.CallerFinder;
import com.google.common.flogger.util.StackBasedLogSite;

public final class StackBasedCallerFinder
extends Platform.LogCallerFinder {
    private static final Platform.LogCallerFinder INSTANCE = new StackBasedCallerFinder();

    public static Platform.LogCallerFinder getInstance() {
        return INSTANCE;
    }

    @Override
    public String findLoggingClass(Class<? extends AbstractLogger<?>> clazz) {
        StackTraceElement stackTraceElement = CallerFinder.findCallerOf(clazz, new Throwable(), 1);
        if (stackTraceElement != null) {
            return stackTraceElement.getClassName();
        }
        throw new IllegalStateException("no caller found on the stack for: " + clazz.getName());
    }

    @Override
    public LogSite findLogSite(Class<?> clazz, int n2) {
        StackTraceElement stackTraceElement = CallerFinder.findCallerOf(clazz, new Throwable(), n2 + 1);
        return stackTraceElement != null ? new StackBasedLogSite(stackTraceElement) : LogSite.INVALID;
    }

    public String toString() {
        return "Default stack-based caller finder";
    }

    private StackBasedCallerFinder() {
    }
}

