/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend.system;

import com.google.common.flogger.backend.LoggerBackend;
import com.google.common.flogger.backend.Platform;
import com.google.common.flogger.backend.Tags;
import com.google.common.flogger.backend.system.BackendFactory;
import com.google.common.flogger.backend.system.Clock;
import com.google.common.flogger.backend.system.EmptyLoggingContext;
import com.google.common.flogger.backend.system.LoggingContext;
import com.google.common.flogger.backend.system.SimpleBackendFactory;
import com.google.common.flogger.backend.system.StackBasedCallerFinder;
import com.google.common.flogger.backend.system.SystemClock;
import com.google.common.flogger.util.Checks;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class DefaultPlatform
extends Platform {
    private static final String BACKEND_FACTORY = "backend_factory";
    private static final String LOGGING_CONTEXT = "logging_context";
    private static final String CLOCK = "clock";
    private final BackendFactory backendFactory;
    private final LoggingContext context;
    private final Clock clock;
    private final Platform.LogCallerFinder callerFinder;

    public DefaultPlatform() {
        BackendFactory backendFactory = DefaultPlatform.resolveAttribute(BACKEND_FACTORY, BackendFactory.class);
        this.backendFactory = backendFactory != null ? backendFactory : SimpleBackendFactory.getInstance();
        LoggingContext loggingContext = DefaultPlatform.resolveAttribute(LOGGING_CONTEXT, LoggingContext.class);
        this.context = loggingContext != null ? loggingContext : EmptyLoggingContext.getInstance();
        Clock clock = DefaultPlatform.resolveAttribute(CLOCK, Clock.class);
        this.clock = clock != null ? clock : SystemClock.getInstance();
        this.callerFinder = StackBasedCallerFinder.getInstance();
    }

    DefaultPlatform(BackendFactory backendFactory, LoggingContext loggingContext, Clock clock, Platform.LogCallerFinder logCallerFinder) {
        this.backendFactory = backendFactory;
        this.context = loggingContext;
        this.clock = clock;
        this.callerFinder = logCallerFinder;
    }

    @Override
    protected Platform.LogCallerFinder getCallerFinderImpl() {
        return this.callerFinder;
    }

    @Override
    protected LoggerBackend getBackendImpl(String string) {
        return this.backendFactory.create(string);
    }

    @Override
    protected boolean shouldForceLoggingImpl(String string, Level level, boolean bl2) {
        return this.context.shouldForceLogging(string, level, bl2);
    }

    @Override
    protected Tags getInjectedTagsImpl() {
        return this.context.getTags();
    }

    @Override
    protected long getCurrentTimeNanosImpl() {
        return this.clock.getCurrentTimeNanos();
    }

    @Override
    protected String getConfigInfoImpl() {
        return "Platform: " + this.getClass().getName() + "\nBackendFactory: " + this.backendFactory + "\nClock: " + this.clock + "\nLoggingContext: " + this.context + "\nLogCallerFinder: " + this.callerFinder + "\n";
    }

    @Nullable
    private static <T> T resolveAttribute(String string, Class<T> clazz) {
        String string2 = DefaultPlatform.readProperty(string);
        if (string2 == null) {
            return null;
        }
        int n2 = string2.indexOf(35);
        if (n2 <= 0 || n2 == string2.length() - 1) {
            DefaultPlatform.error("invalid getter (expected <class>#<method>): %s\n", string2);
            return null;
        }
        return DefaultPlatform.callStaticMethod(string2.substring(0, n2), string2.substring(n2 + 1), clazz);
    }

    private static String readProperty(String string) {
        Checks.checkNotNull(string, "attribute name");
        String string2 = "flogger." + string;
        try {
            return System.getProperty(string2);
        }
        catch (SecurityException securityException) {
            DefaultPlatform.error("cannot read property name %s: %s", string2, securityException);
            return null;
        }
    }

    private static <T> T callStaticMethod(String string, String string2, Class<T> clazz) {
        try {
            return clazz.cast(Class.forName(string).getMethod(string2, new Class[0]).invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ClassCastException classCastException) {
            DefaultPlatform.error("cannot cast result of calling '%s#%s' to '%s': %s\n", string, string2, clazz.getName(), classCastException);
        }
        catch (Exception exception) {
            DefaultPlatform.error("cannot call expected no-argument static method '%s#%s': %s\n", string, string2, exception);
        }
        return null;
    }

    private static void error(String string, Object ... objectArray) {
        System.err.println(DefaultPlatform.class + ": " + String.format(string, objectArray));
    }
}

