/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend.system;

import com.google.common.flogger.LogSite;
import com.google.common.flogger.backend.LogData;
import com.google.common.flogger.backend.SimpleMessageFormatter;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public abstract class AbstractLogRecord
extends LogRecord {
    private final LogData data;

    AbstractLogRecord(LogData logData) {
        super(logData.getLevel(), null);
        this.data = logData;
        LogSite logSite = logData.getLogSite();
        this.setSourceClassName(logSite.getClassName());
        this.setSourceMethodName(logSite.getMethodName());
        this.setLoggerName(logData.getLoggerName());
        this.setMillis(TimeUnit.NANOSECONDS.toMillis(logData.getTimestampNanos()));
    }

    AbstractLogRecord(RuntimeException runtimeException, LogData logData) {
        this(logData);
        this.setLevel(logData.getLevel().intValue() < Level.WARNING.intValue() ? Level.WARNING : logData.getLevel());
        this.setThrown(runtimeException);
        StringBuilder stringBuilder = new StringBuilder("LOGGING ERROR: ").append(runtimeException.getMessage()).append('\n');
        AbstractLogRecord.safeAppend(logData, stringBuilder);
        this.setMessage(stringBuilder.toString());
    }

    public final LogData getLogData() {
        return this.data;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName()).append(" {\n  message: ").append(this.getMessage()).append("\n  arguments: ").append(this.getParameters() != null ? Arrays.asList(this.getParameters()) : "<none>").append('\n');
        AbstractLogRecord.safeAppend(this.getLogData(), stringBuilder);
        stringBuilder.append("\n}");
        return stringBuilder.toString();
    }

    private static void safeAppend(LogData logData, StringBuilder stringBuilder) {
        stringBuilder.append("  original message: ");
        if (logData.getTemplateContext() == null) {
            stringBuilder.append(logData.getLiteralArgument());
        } else {
            stringBuilder.append(logData.getTemplateContext().getMessage());
            stringBuilder.append("\n  original arguments:");
            for (Object object : logData.getArguments()) {
                stringBuilder.append("\n    ").append(SimpleMessageFormatter.safeToString(object));
            }
        }
        Object[] objectArray = logData.getMetadata();
        if (objectArray.size() > 0) {
            stringBuilder.append("\n  metadata:");
            for (int i2 = 0; i2 < objectArray.size(); ++i2) {
                stringBuilder.append("\n    ");
                stringBuilder.append(objectArray.getKey(i2).getLabel()).append(": ").append(objectArray.getValue(i2));
            }
        }
        stringBuilder.append("\n  level: ").append(logData.getLevel());
        stringBuilder.append("\n  timestamp (nanos): ").append(logData.getTimestampNanos());
        stringBuilder.append("\n  class: ").append(logData.getLogSite().getClassName());
        stringBuilder.append("\n  method: ").append(logData.getLogSite().getMethodName());
        stringBuilder.append("\n  line number: ").append(logData.getLogSite().getLineNumber());
    }
}

