/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend.system;

import com.google.common.flogger.backend.LoggerBackend;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

abstract class AbstractBackend
extends LoggerBackend {
    private static volatile boolean cannotUseForcingLogger = false;
    private final Logger logger;

    AbstractBackend(Logger logger) {
        this.logger = logger;
    }

    @Override
    public final String getLoggerName() {
        return this.logger.getName();
    }

    @Override
    public final boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    void log(LogRecord logRecord, boolean bl2) {
        if (!bl2 || this.logger.isLoggable(logRecord.getLevel())) {
            this.logger.log(logRecord);
        } else {
            Filter filter = this.logger.getFilter();
            if (filter != null) {
                filter.isLoggable(logRecord);
            }
            if (this.logger.getClass() == Logger.class || cannotUseForcingLogger) {
                AbstractBackend.publish(this.logger, logRecord);
            } else {
                this.forceLoggingViaChildLogger(logRecord);
            }
        }
    }

    private static void publish(Logger logger, LogRecord logRecord) {
        for (Handler handler : logger.getHandlers()) {
            handler.publish(logRecord);
        }
        if (logger.getUseParentHandlers() && (logger = logger.getParent()) != null) {
            AbstractBackend.publish(logger, logRecord);
        }
    }

    void forceLoggingViaChildLogger(LogRecord logRecord) {
        Logger logger = this.getForcingLogger(this.logger);
        try {
            logger.setLevel(Level.ALL);
        }
        catch (SecurityException securityException) {
            cannotUseForcingLogger = true;
            Logger.getLogger("").log(Level.SEVERE, "Forcing log statements with Flogger has been partially disabled.\nThe Flogger library cannot modify logger log levels, which is necessary to force log statements. This is likely due to an installed SecurityManager.\nForced log statements will still be published directly to log handlers, but will not be visible to the 'log(LogRecord)' method of Logger sub-classes.\n");
            AbstractBackend.publish(this.logger, logRecord);
            return;
        }
        logger.log(logRecord);
    }

    Logger getForcingLogger(Logger logger) {
        return Logger.getLogger(logger.getName() + ".__forced__");
    }
}

