/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend;

import com.google.common.flogger.backend.KeyValueFormatter;
import com.google.common.flogger.backend.KeyValueHandler;
import com.google.common.flogger.util.Checks;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;

public final class Tags {
    private static final Comparator<Object> VALUE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            Type type;
            Type type2 = Type.of(object);
            return type2 == (type = Type.of(object2)) ? type2.compare(object, object2) : type2.compareTo(type);
        }
    };
    private static final SortedSet<Object> EMPTY_SET = Collections.unmodifiableSortedSet(new TreeSet());
    private static final Tags EMPTY_TAGS = new Tags(Collections.unmodifiableSortedMap(new TreeMap()));
    private final SortedMap<String, SortedSet<Object>> map;
    private Integer hashCode = null;
    private String toString = null;

    public static Builder builder() {
        return new Builder();
    }

    public static Tags empty() {
        return EMPTY_TAGS;
    }

    private Tags(SortedMap<String, SortedSet<Object>> sortedMap) {
        this.map = sortedMap;
    }

    public SortedMap<String, SortedSet<Object>> asMap() {
        return this.map;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Tags merge(Tags tags) {
        if (tags.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return tags;
        }
        TreeMap<String, SortedSet<Object>> treeMap = new TreeMap<String, SortedSet<Object>>();
        for (Map.Entry<String, SortedSet<Object>> entry : this.map.entrySet()) {
            SortedSet sortedSet = (SortedSet)tags.map.get(entry.getKey());
            if (sortedSet == null || entry.getValue().containsAll(sortedSet)) {
                treeMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (sortedSet.containsAll((Collection)entry.getValue())) {
                treeMap.put(entry.getKey(), sortedSet);
                continue;
            }
            TreeSet<Object> treeSet = new TreeSet<Object>(entry.getValue());
            treeSet.addAll(sortedSet);
            treeMap.put(entry.getKey(), Collections.unmodifiableSortedSet(treeSet));
        }
        for (Map.Entry<String, SortedSet<Object>> entry : tags.map.entrySet()) {
            if (this.map.containsKey(entry.getKey())) continue;
            treeMap.put(entry.getKey(), entry.getValue());
        }
        return new Tags(Collections.unmodifiableSortedMap(treeMap));
    }

    public void emitAll(KeyValueHandler keyValueHandler) {
        for (Map.Entry<String, SortedSet<Object>> entry : this.map.entrySet()) {
            String string = entry.getKey();
            Set set = entry.getValue();
            if (!set.isEmpty()) {
                for (Object e2 : set) {
                    keyValueHandler.handle(string, e2);
                }
                continue;
            }
            keyValueHandler.handle(string, null);
        }
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof Tags && ((Tags)object).map.equals(this.map);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.map.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuilder stringBuilder = new StringBuilder();
            KeyValueFormatter keyValueFormatter = new KeyValueFormatter("[ ", " ]", stringBuilder);
            this.emitAll(keyValueFormatter);
            keyValueFormatter.done();
            this.toString = stringBuilder.toString();
        }
        return this.toString;
    }

    public static final class Builder {
        private final SortedMap<String, SortedSet<Object>> map = new TreeMap<String, SortedSet<Object>>();

        @CanIgnoreReturnValue
        public Builder addTag(String string) {
            Set set = (Set)this.map.get(Checks.checkMetadataIdentifier(string));
            if (set == null) {
                this.map.put(string, EMPTY_SET);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTag(String string, String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("tag values cannot be null");
            }
            this.addImpl(string, string2);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTag(String string, boolean bl2) {
            this.addImpl(string, bl2);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTag(String string, long l2) {
            this.addImpl(string, l2);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTag(String string, double d2) {
            this.addImpl(string, d2);
            return this;
        }

        private void addImpl(String string, Object object) {
            TreeSet<Object> treeSet = (TreeSet<Object>)this.map.get(Checks.checkMetadataIdentifier(string));
            if (treeSet == null || treeSet == EMPTY_SET) {
                treeSet = new TreeSet<Object>(VALUE_COMPARATOR);
                this.map.put(string, treeSet);
            }
            treeSet.add(object);
        }

        public Tags build() {
            if (this.map.isEmpty()) {
                return EMPTY_TAGS;
            }
            TreeMap<String, SortedSet<Object>> treeMap = new TreeMap<String, SortedSet<Object>>();
            for (Map.Entry<String, SortedSet<Object>> entry : this.map.entrySet()) {
                treeMap.put(entry.getKey(), Collections.unmodifiableSortedSet(new TreeSet<Object>(entry.getValue())));
            }
            return new Tags(Collections.unmodifiableSortedMap(treeMap));
        }

        public String toString() {
            return this.build().toString();
        }
    }

    private static enum Type {
        BOOLEAN{

            @Override
            int compare(Object object, Object object2) {
                return ((Boolean)object).compareTo((Boolean)object2);
            }
        }
        ,
        STRING{

            @Override
            int compare(Object object, Object object2) {
                return ((String)object).compareTo((String)object2);
            }
        }
        ,
        LONG{

            @Override
            int compare(Object object, Object object2) {
                return ((Long)object).compareTo((Long)object2);
            }
        }
        ,
        DOUBLE{

            @Override
            int compare(Object object, Object object2) {
                return ((Double)object).compareTo((Double)object2);
            }
        };


        abstract int compare(Object var1, Object var2);

        private static Type of(Object object) {
            if (object instanceof String) {
                return STRING;
            }
            if (object instanceof Boolean) {
                return BOOLEAN;
            }
            if (object instanceof Long) {
                return LONG;
            }
            if (object instanceof Double) {
                return DOUBLE;
            }
            throw new AssertionError((Object)("invalid tag type: " + object.getClass()));
        }
    }
}

