/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend;

import com.google.common.flogger.LogContext;
import com.google.common.flogger.MetadataKey;
import com.google.common.flogger.backend.FormatChar;
import com.google.common.flogger.backend.FormatOptions;
import com.google.common.flogger.backend.KeyValueFormatter;
import com.google.common.flogger.backend.LogData;
import com.google.common.flogger.backend.Metadata;
import com.google.common.flogger.backend.Tags;
import com.google.common.flogger.backend.TemplateContext;
import com.google.common.flogger.parameter.DateTimeFormat;
import com.google.common.flogger.parameter.Parameter;
import com.google.common.flogger.parameter.ParameterVisitor;
import com.google.common.flogger.parser.MessageBuilder;
import com.google.common.flogger.util.Checks;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Locale;
import java.util.logging.Level;
import javax.annotation.Nullable;

public final class SimpleMessageFormatter
extends MessageBuilder<StringBuilder>
implements ParameterVisitor {
    private static final String MISSING_ARGUMENT_MESSAGE = "[ERROR: MISSING LOG ARGUMENT]";
    private static final String EXTRA_ARGUMENT_MESSAGE = " [ERROR: UNUSED LOG ARGUMENTS]";
    private static final Locale FORMAT_LOCALE = Locale.ROOT;
    private final Object[] args;
    private final StringBuilder out = new StringBuilder();
    private int literalStart = 0;

    public static void format(LogData logData, SimpleLogHandler simpleLogHandler) {
        String string;
        Metadata metadata = logData.getMetadata();
        Throwable throwable = metadata.findValue(LogContext.Key.LOG_CAUSE);
        boolean bl2 = metadata.size() == 0 || metadata.size() == 1 && throwable != null;
        TemplateContext templateContext = logData.getTemplateContext();
        if (templateContext == null) {
            string = SimpleMessageFormatter.safeToString(logData.getLiteralArgument());
            if (!bl2) {
                string = SimpleMessageFormatter.appendContext(new StringBuilder(string), metadata);
            }
        } else {
            StringBuilder stringBuilder = SimpleMessageFormatter.formatMessage(logData);
            string = bl2 ? stringBuilder.toString() : SimpleMessageFormatter.appendContext(stringBuilder, metadata);
        }
        simpleLogHandler.handleFormattedLogMessage(logData.getLevel(), string, throwable);
    }

    public static String safeToString(Object object) {
        try {
            return object != null ? SimpleMessageFormatter.toString(object) : "null";
        }
        catch (RuntimeException runtimeException) {
            return SimpleMessageFormatter.getErrorString(object, runtimeException);
        }
    }

    private static void safeFormatTo(Formattable formattable, StringBuilder stringBuilder, FormatOptions formatOptions) {
        int n2 = formatOptions.getFlags() & 0xA2;
        if (n2 != 0) {
            n2 = ((n2 & 0x20) != 0 ? 1 : 0) | ((n2 & 0x80) != 0 ? 2 : 0) | ((n2 & 2) != 0 ? 4 : 0);
        }
        int n3 = stringBuilder.length();
        Formatter formatter = new Formatter(stringBuilder, FORMAT_LOCALE);
        try {
            formattable.formatTo(formatter, n2, formatOptions.getWidth(), formatOptions.getPrecision());
        }
        catch (RuntimeException runtimeException) {
            stringBuilder.setLength(n3);
            try {
                formatter.out().append(SimpleMessageFormatter.getErrorString(formattable, runtimeException));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String getErrorString(Object object, RuntimeException runtimeException) {
        String string;
        try {
            string = runtimeException.toString();
        }
        catch (RuntimeException runtimeException2) {
            string = runtimeException2.getClass().getSimpleName();
        }
        return "{" + object.getClass().getName() + "@" + System.identityHashCode(object) + ": " + string + "}";
    }

    private static StringBuilder formatMessage(LogData logData) {
        SimpleMessageFormatter simpleMessageFormatter = new SimpleMessageFormatter(logData.getTemplateContext(), logData.getArguments());
        StringBuilder stringBuilder = (StringBuilder)simpleMessageFormatter.build();
        if (logData.getArguments().length > simpleMessageFormatter.getExpectedArgumentCount()) {
            stringBuilder.append(EXTRA_ARGUMENT_MESSAGE);
        }
        return stringBuilder;
    }

    private static String appendContext(StringBuilder stringBuilder, Metadata metadata) {
        KeyValueFormatter keyValueFormatter = new KeyValueFormatter("[CONTEXT ", " ]", stringBuilder);
        Tags tags = null;
        for (int i2 = 0; i2 < metadata.size(); ++i2) {
            MetadataKey<?> metadataKey = metadata.getKey(i2);
            if (metadataKey.equals(LogContext.Key.LOG_CAUSE)) continue;
            if (metadataKey.equals(LogContext.Key.TAGS)) {
                tags = LogContext.Key.TAGS.cast(metadata.getValue(i2));
                continue;
            }
            metadataKey.emit(metadata.getValue(i2), keyValueFormatter);
        }
        if (tags != null) {
            tags.emitAll(keyValueFormatter);
        }
        keyValueFormatter.done();
        return stringBuilder.toString();
    }

    private SimpleMessageFormatter(TemplateContext templateContext, Object[] objectArray) {
        super(templateContext);
        this.args = Checks.checkNotNull(objectArray, "log arguments");
    }

    @Override
    public void addParameterImpl(int n2, int n3, Parameter parameter) {
        this.getParser().unescape(this.out, this.getMessage(), this.literalStart, n2);
        parameter.accept((ParameterVisitor)this, this.args);
        this.literalStart = n3;
    }

    @Override
    public StringBuilder buildImpl() {
        this.getParser().unescape(this.out, this.getMessage(), this.literalStart, this.getMessage().length());
        return this.out;
    }

    @Override
    public void visit(Object object, FormatChar formatChar, FormatOptions formatOptions) {
        if (formatChar.getType().canFormat(object)) {
            SimpleMessageFormatter.appendFormatted(this.out, object, formatChar, formatOptions);
        } else {
            SimpleMessageFormatter.appendInvalid(this.out, object, formatChar.getDefaultFormatString());
        }
    }

    @Override
    public void visitDateTime(Object object, DateTimeFormat dateTimeFormat, FormatOptions formatOptions) {
        if (object instanceof Date || object instanceof Calendar || object instanceof Long) {
            String string = formatOptions.appendPrintfOptions(new StringBuilder("%")).append(formatOptions.shouldUpperCase() ? (char)'T' : 't').append(dateTimeFormat.getChar()).toString();
            this.out.append(String.format(FORMAT_LOCALE, string, object));
        } else {
            SimpleMessageFormatter.appendInvalid(this.out, object, "%t" + dateTimeFormat.getChar());
        }
    }

    @Override
    public void visitPreformatted(Object object, String string) {
        this.out.append(string);
    }

    @Override
    public void visitMissing() {
        this.out.append(MISSING_ARGUMENT_MESSAGE);
    }

    @Override
    public void visitNull() {
        this.out.append("null");
    }

    private static void appendFormatted(StringBuilder stringBuilder, Object object, FormatChar formatChar, FormatOptions formatOptions) {
        switch (formatChar) {
            case STRING: {
                if (!(object instanceof Formattable)) {
                    if (!formatOptions.isDefault()) break;
                    stringBuilder.append(SimpleMessageFormatter.safeToString(object));
                    return;
                }
                SimpleMessageFormatter.safeFormatTo((Formattable)object, stringBuilder, formatOptions);
                return;
            }
            case DECIMAL: 
            case BOOLEAN: {
                if (!formatOptions.isDefault()) break;
                stringBuilder.append(object);
                return;
            }
            case HEX: {
                if (!formatOptions.filter(128, false, false).equals(formatOptions)) break;
                SimpleMessageFormatter.appendHex(stringBuilder, (Number)object, formatOptions);
                return;
            }
            case CHAR: {
                if (!formatOptions.isDefault()) break;
                if (object instanceof Character) {
                    stringBuilder.append(object);
                    return;
                }
                int n2 = ((Number)object).intValue();
                if (Character.isBmpCodePoint(n2)) {
                    stringBuilder.append((char)n2);
                    return;
                }
                stringBuilder.append(Character.toChars(n2));
                return;
            }
        }
        String string = formatChar.getDefaultFormatString();
        if (!formatOptions.isDefault()) {
            char c2 = formatChar.getChar();
            if (formatOptions.shouldUpperCase()) {
                c2 = (char)(c2 & 0xFFDF);
            }
            string = formatOptions.appendPrintfOptions(new StringBuilder("%")).append(c2).toString();
        }
        stringBuilder.append(String.format(FORMAT_LOCALE, string, object));
    }

    static void appendHex(StringBuilder stringBuilder, Number number, FormatOptions formatOptions) {
        boolean bl2 = formatOptions.shouldUpperCase();
        long l2 = number.longValue();
        if (number instanceof Long) {
            SimpleMessageFormatter.appendHex(stringBuilder, l2, bl2);
        } else if (number instanceof Integer) {
            SimpleMessageFormatter.appendHex(stringBuilder, l2 & 0xFFFFFFFFL, bl2);
        } else if (number instanceof Byte) {
            SimpleMessageFormatter.appendHex(stringBuilder, l2 & 0xFFL, bl2);
        } else if (number instanceof Short) {
            SimpleMessageFormatter.appendHex(stringBuilder, l2 & 0xFFFFL, bl2);
        } else if (number instanceof BigInteger) {
            String string = ((BigInteger)number).toString(16);
            stringBuilder.append(bl2 ? string.toUpperCase(FORMAT_LOCALE) : string);
        } else {
            throw new RuntimeException("unsupported number type: " + number.getClass());
        }
    }

    private static void appendHex(StringBuilder stringBuilder, long l2, boolean bl2) {
        if (l2 == 0L) {
            stringBuilder.append("0");
        } else {
            String string = bl2 ? "0123456789ABCDEF" : "0123456789abcdef";
            for (int i2 = 63 - Long.numberOfLeadingZeros(l2) & 0xFFFFFFFC; i2 >= 0; i2 -= 4) {
                stringBuilder.append(string.charAt((int)(l2 >>> i2 & 0xFL)));
            }
        }
    }

    private static void appendInvalid(StringBuilder stringBuilder, Object object, String string) {
        stringBuilder.append("[INVALID: format=").append(string).append(", type=").append(object.getClass().getCanonicalName()).append(", value=").append(SimpleMessageFormatter.safeToString(object)).append("]");
    }

    static String toString(Object object) {
        if (!object.getClass().isArray()) {
            return String.valueOf(object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.toString((char[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.toString((boolean[])object);
        }
        return Arrays.toString((Object[])object);
    }

    public static interface SimpleLogHandler {
        public void handleFormattedLogMessage(Level var1, String var2, @Nullable Throwable var3);
    }
}

