/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend;

import com.google.common.flogger.AbstractLogger;
import com.google.common.flogger.LogSite;
import com.google.common.flogger.backend.LoggerBackend;
import com.google.common.flogger.backend.PlatformProvider;
import com.google.common.flogger.backend.Tags;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public abstract class Platform {
    private static String ANDROID_PLATFORM = "com.google.common.flogger.backend.android.AndroidPlatform";
    private static String DEFAULT_PLATFORM = "com.google.common.flogger.backend.system.DefaultPlatform";
    private static final String[] AVAILABLE_PLATFORMS = new String[]{DEFAULT_PLATFORM};

    public static LogCallerFinder getCallerFinder() {
        return LazyHolder.INSTANCE.getCallerFinderImpl();
    }

    protected abstract LogCallerFinder getCallerFinderImpl();

    public static LoggerBackend getBackend(String string) {
        return LazyHolder.INSTANCE.getBackendImpl(string);
    }

    protected abstract LoggerBackend getBackendImpl(String var1);

    public static boolean shouldForceLogging(String string, Level level, boolean bl2) {
        return LazyHolder.INSTANCE.shouldForceLoggingImpl(string, level, bl2);
    }

    protected boolean shouldForceLoggingImpl(String string, Level level, boolean bl2) {
        return false;
    }

    public static Tags getInjectedTags() {
        return LazyHolder.INSTANCE.getInjectedTagsImpl();
    }

    protected Tags getInjectedTagsImpl() {
        return Tags.empty();
    }

    public static long getCurrentTimeNanos() {
        return LazyHolder.INSTANCE.getCurrentTimeNanosImpl();
    }

    protected long getCurrentTimeNanosImpl() {
        return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    }

    public static String getConfigInfo() {
        return LazyHolder.INSTANCE.getConfigInfoImpl();
    }

    protected abstract String getConfigInfoImpl();

    static /* synthetic */ String[] access$000() {
        return AVAILABLE_PLATFORMS;
    }

    public static abstract class LogCallerFinder {
        public abstract String findLoggingClass(Class<? extends AbstractLogger<?>> var1);

        public abstract LogSite findLogSite(Class<?> var1, int var2);
    }

    private static final class LazyHolder {
        private static final Platform INSTANCE = LazyHolder.loadFirstAvailablePlatform(Platform.access$000());

        private LazyHolder() {
        }

        private static Platform loadFirstAvailablePlatform(String[] stringArray) {
            StringBuilder stringBuilder = new StringBuilder();
            Platform platform = null;
            try {
                platform = PlatformProvider.getPlatform();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            if (platform != null) {
                return platform;
            }
            for (String string : stringArray) {
                try {
                    return (Platform)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (throwable instanceof InvocationTargetException) {
                        throwable2 = throwable.getCause();
                    }
                    stringBuilder.append('\n').append(string).append(": ").append(throwable2);
                }
            }
            throw new IllegalStateException(stringBuilder.insert(0, "No logging platforms found:").toString());
        }
    }
}

