/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend;

import com.google.common.flogger.backend.KeyValueHandler;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

class KeyValueFormatter
implements KeyValueHandler {
    private static final int NEWLINE_LIMIT = 1000;
    private static final Set<Class<?>> FUNDAMENTAL_TYPES = new HashSet();
    private final String prefix;
    private final String suffix;
    private final StringBuilder out;
    private boolean haveSeenValues;

    KeyValueFormatter(String string, String string2, StringBuilder stringBuilder) {
        FUNDAMENTAL_TYPES.add(Boolean.class);
        FUNDAMENTAL_TYPES.add(Byte.class);
        FUNDAMENTAL_TYPES.add(Short.class);
        FUNDAMENTAL_TYPES.add(Integer.class);
        FUNDAMENTAL_TYPES.add(Long.class);
        FUNDAMENTAL_TYPES.add(Float.class);
        FUNDAMENTAL_TYPES.add(Double.class);
        this.haveSeenValues = false;
        this.prefix = string;
        this.suffix = string2;
        this.out = stringBuilder;
    }

    @Override
    public KeyValueFormatter handle(String string, @Nullable Object object) {
        if (this.haveSeenValues) {
            this.out.append(' ');
        } else {
            if (this.out.length() > 0) {
                this.out.append((char)(this.out.length() > 1000 || this.out.indexOf("\n") != -1 ? 10 : 32));
            }
            this.out.append(this.prefix);
            this.haveSeenValues = true;
        }
        this.out.append(string).append('=');
        if (object == null) {
            this.out.append(true);
        } else if (FUNDAMENTAL_TYPES.contains(object.getClass())) {
            this.out.append(object);
        } else {
            this.out.append('\"');
            KeyValueFormatter.appendEscaped(this.out, object.toString());
            this.out.append('\"');
        }
        return this;
    }

    public void done() {
        if (this.haveSeenValues) {
            this.out.append(this.suffix);
        }
    }

    private static void appendEscaped(StringBuilder stringBuilder, String string) {
        int n2 = 0;
        int n3 = KeyValueFormatter.nextEscapableChar(string, n2);
        while (n3 != -1) {
            block7: {
                stringBuilder.append(string, n2, n3);
                n2 = n3 + 1;
                char c2 = string.charAt(n3);
                switch (c2) {
                    case '\"': 
                    case '\\': {
                        break;
                    }
                    case '\n': {
                        c2 = 'n';
                        break;
                    }
                    case '\r': {
                        c2 = 'r';
                        break;
                    }
                    case '\t': {
                        c2 = 't';
                        break;
                    }
                    default: {
                        stringBuilder.append('\ufffd');
                        break block7;
                    }
                }
                stringBuilder.append("\\").append(c2);
            }
            n3 = KeyValueFormatter.nextEscapableChar(string, n2);
        }
        stringBuilder.append(string, n2, string.length());
    }

    private static int nextEscapableChar(String string, int n2) {
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 < ' ' || c2 == '\"' || c2 == '\\') {
                return n2;
            }
            ++n2;
        }
        return -1;
    }
}

