/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend;

import java.math.BigDecimal;
import java.math.BigInteger;

public enum FormatType {
    GENERAL(false, true){

        @Override
        public boolean canFormat(Object object) {
            return true;
        }
    }
    ,
    BOOLEAN(false, false){

        @Override
        public boolean canFormat(Object object) {
            return object instanceof Boolean;
        }
    }
    ,
    CHARACTER(false, false){

        @Override
        public boolean canFormat(Object object) {
            if (object instanceof Character) {
                return true;
            }
            if (object instanceof Integer || object instanceof Byte || object instanceof Short) {
                return Character.isValidCodePoint(((Number)object).intValue());
            }
            return false;
        }
    }
    ,
    INTEGRAL(true, false){

        @Override
        public boolean canFormat(Object object) {
            return object instanceof Integer || object instanceof Long || object instanceof Byte || object instanceof Short || object instanceof BigInteger;
        }
    }
    ,
    FLOAT(true, true){

        @Override
        public boolean canFormat(Object object) {
            return object instanceof Double || object instanceof Float || object instanceof BigDecimal;
        }
    };

    private final boolean isNumeric;
    private final boolean supportsPrecision;

    private FormatType(boolean bl2, boolean bl3) {
        this.isNumeric = bl2;
        this.supportsPrecision = bl3;
    }

    boolean supportsPrecision() {
        return this.supportsPrecision;
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public abstract boolean canFormat(Object var1);
}

