/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend;

import com.google.common.flogger.backend.FormatChar;
import com.google.common.flogger.parser.ParseException;
import javax.annotation.Nullable;

public final class FormatOptions {
    private static final int MAX_ALLOWED_WIDTH = 999999;
    private static final int MAX_ALLOWED_PRECISION = 999999;
    private static final String FLAG_CHARS_ORDERED = " #(+,-0";
    private static final int MIN_FLAG_VALUE = 32;
    private static final int MAX_FLAG_VALUE = 48;
    private static final long ENCODED_FLAG_INDICES;
    public static final int FLAG_PREFIX_SPACE_FOR_POSITIVE_VALUES = 1;
    public static final int FLAG_SHOW_ALT_FORM = 2;
    public static final int FLAG_USE_PARENS_FOR_NEGATIVE_VALUES = 4;
    public static final int FLAG_PREFIX_PLUS_FOR_POSITIVE_VALUES = 8;
    public static final int FLAG_SHOW_GROUPING = 16;
    public static final int FLAG_LEFT_ALIGN = 32;
    public static final int FLAG_SHOW_LEADING_ZEROS = 64;
    public static final int FLAG_UPPER_CASE = 128;
    public static final int ALL_FLAGS = 255;
    public static final int UNSET = -1;
    private static final FormatOptions DEFAULT;
    private final int flags;
    private final int width;
    private final int precision;

    private static int indexOfFlagCharacter(char c2) {
        return (int)(ENCODED_FLAG_INDICES >>> 3 * (c2 - 32) & 7L) - 1;
    }

    public static FormatOptions getDefault() {
        return DEFAULT;
    }

    public static FormatOptions of(int n2, int n3, int n4) {
        if (!FormatOptions.checkFlagConsistency(n2, n3 != -1)) {
            throw new IllegalArgumentException("invalid flags: 0x" + Integer.toHexString(n2));
        }
        if ((n3 < 1 || n3 > 999999) && n3 != -1) {
            throw new IllegalArgumentException("invalid width: " + n3);
        }
        if ((n4 < 0 || n4 > 999999) && n4 != -1) {
            throw new IllegalArgumentException("invalid precision: " + n4);
        }
        return new FormatOptions(n2, n3, n4);
    }

    public static FormatOptions parse(String string, int n2, int n3, boolean bl2) {
        char c2;
        int n4;
        int n5;
        char c3;
        int n6;
        if (n2 == n3 && !bl2) {
            return DEFAULT;
        }
        int n7 = n6 = bl2 ? 128 : 0;
        while (true) {
            if (n2 == n3) {
                return new FormatOptions(n6, -1, -1);
            }
            if ((c3 = string.charAt(n2++)) < ' ' || c3 > '0') break;
            n5 = FormatOptions.indexOfFlagCharacter(c3);
            if (n5 < 0) {
                if (c3 == '.') {
                    return new FormatOptions(n6, -1, FormatOptions.parsePrecision(string, n2, n3));
                }
                throw ParseException.atPosition("invalid flag", string, n2 - 1);
            }
            n4 = 1 << n5;
            if ((n6 & n4) != 0) {
                throw ParseException.atPosition("repeated flag", string, n2 - 1);
            }
            n6 |= n4;
        }
        n5 = n2 - 1;
        if (c3 > '9') {
            throw ParseException.atPosition("invalid flag", string, n5);
        }
        n4 = c3 - 48;
        do {
            if (n2 == n3) {
                return new FormatOptions(n6, n4, -1);
            }
            if ((c3 = string.charAt(n2++)) == '.') {
                return new FormatOptions(n6, n4, FormatOptions.parsePrecision(string, n2, n3));
            }
            c2 = (char)(c3 - 48);
            if (c2 < '\n') continue;
            throw ParseException.atPosition("invalid width character", string, n2 - 1);
        } while ((n4 = n4 * 10 + c2) <= 999999);
        throw ParseException.withBounds("width too large", string, n5, n3);
    }

    private static int parsePrecision(String string, int n2, int n3) {
        if (n2 == n3) {
            throw ParseException.atPosition("missing precision", string, n2 - 1);
        }
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = (char)(string.charAt(i2) - 48);
            if (c2 >= '\n') {
                throw ParseException.atPosition("invalid precision character", string, i2);
            }
            if ((n4 = n4 * 10 + c2) <= 999999) continue;
            throw ParseException.withBounds("precision too large", string, n2, n3);
        }
        if (n4 == 0 && n3 != n2 + 1) {
            throw ParseException.withBounds("invalid precision", string, n2, n3);
        }
        return n4;
    }

    static int parseValidFlags(String string, boolean bl2) {
        int n2 = bl2 ? 128 : 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n3 = FormatOptions.indexOfFlagCharacter(string.charAt(i2));
            if (n3 < 0) {
                throw new IllegalArgumentException("invalid flags: " + string);
            }
            n2 |= 1 << n3;
        }
        return n2;
    }

    private FormatOptions(int n2, int n3, int n4) {
        this.flags = n2;
        this.width = n3;
        this.precision = n4;
    }

    public FormatOptions filter(int n2, boolean bl2, boolean bl3) {
        int n3;
        if (this.isDefault()) {
            return this;
        }
        int n4 = n2 & this.flags;
        int n5 = bl2 ? this.width : -1;
        int n6 = n3 = bl3 ? this.precision : -1;
        if (n4 == 0 && n5 == -1 && n3 == -1) {
            return DEFAULT;
        }
        if (n4 == this.flags && n5 == this.width && n3 == this.precision) {
            return this;
        }
        return new FormatOptions(n4, n5, n3);
    }

    public boolean isDefault() {
        return this == FormatOptions.getDefault();
    }

    public int getWidth() {
        return this.width;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean validate(int n2, boolean bl2) {
        if (this.isDefault()) {
            return true;
        }
        if ((this.flags & ~n2) != 0) {
            return false;
        }
        if (!bl2 && this.precision != -1) {
            return false;
        }
        return FormatOptions.checkFlagConsistency(this.flags, this.getWidth() != -1);
    }

    static boolean checkFlagConsistency(int n2, boolean bl2) {
        if ((n2 & 9) == 9) {
            return false;
        }
        if ((n2 & 0x60) == 96) {
            return false;
        }
        return (n2 & 0x60) == 0 || bl2;
    }

    public boolean areValidFor(FormatChar formatChar) {
        return this.validate(formatChar.getAllowedFlags(), formatChar.getType().supportsPrecision());
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean shouldLeftAlign() {
        return (this.flags & 0x20) != 0;
    }

    public boolean shouldShowAltForm() {
        return (this.flags & 2) != 0;
    }

    public boolean shouldShowLeadingZeros() {
        return (this.flags & 0x40) != 0;
    }

    public boolean shouldPrefixPlusForPositiveValues() {
        return (this.flags & 8) != 0;
    }

    public boolean shouldPrefixSpaceForPositiveValues() {
        return (this.flags & 1) != 0;
    }

    public boolean shouldShowGrouping() {
        return (this.flags & 0x10) != 0;
    }

    public boolean shouldUpperCase() {
        return (this.flags & 0x80) != 0;
    }

    public StringBuilder appendPrintfOptions(StringBuilder stringBuilder) {
        if (!this.isDefault()) {
            int n2 = this.flags & 0xFFFFFF7F;
            int n3 = 0;
            while (1 << n3 <= n2) {
                if ((n2 & 1 << n3) != 0) {
                    stringBuilder.append(FLAG_CHARS_ORDERED.charAt(n3));
                }
                ++n3;
            }
            if (this.width != -1) {
                stringBuilder.append(this.width);
            }
            if (this.precision != -1) {
                stringBuilder.append('.').append(this.precision);
            }
        }
        return stringBuilder;
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FormatOptions) {
            FormatOptions formatOptions = (FormatOptions)object;
            return formatOptions.flags == this.flags && formatOptions.width == this.width && formatOptions.precision == this.precision;
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.flags;
        n2 = 31 * n2 + this.width;
        n2 = 31 * n2 + this.precision;
        return n2;
    }

    static {
        long l2 = 0L;
        for (int i2 = 0; i2 < FLAG_CHARS_ORDERED.length(); ++i2) {
            long l3 = FLAG_CHARS_ORDERED.charAt(i2) - 32;
            l2 |= (long)i2 + 1L << (int)(3L * l3);
        }
        ENCODED_FLAG_INDICES = l2;
        DEFAULT = new FormatOptions(0, -1, -1);
    }
}

