/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend;

import com.google.common.flogger.backend.FormatOptions;
import com.google.common.flogger.backend.FormatType;

public enum FormatChar {
    STRING('s', FormatType.GENERAL, "-#", true),
    BOOLEAN('b', FormatType.BOOLEAN, "-", true),
    CHAR('c', FormatType.CHARACTER, "-", true),
    DECIMAL('d', FormatType.INTEGRAL, "-0+ ,", false),
    OCTAL('o', FormatType.INTEGRAL, "-#0", false),
    HEX('x', FormatType.INTEGRAL, "-#0", true),
    FLOAT('f', FormatType.FLOAT, "-#0+ ,", false),
    EXPONENT('e', FormatType.FLOAT, "-#0+ ", true),
    GENERAL('g', FormatType.FLOAT, "-0+ ,", true),
    EXPONENT_HEX('a', FormatType.FLOAT, "-#0+ ", true);

    private static final FormatChar[] MAP;
    private final char formatChar;
    private final FormatType type;
    private final int allowedFlags;
    private final String defaultFormatString;

    private static int indexOf(char c2) {
        return (c2 | 0x20) - 97;
    }

    private static boolean isLowerCase(char c2) {
        return (c2 & 0x20) != 0;
    }

    public static FormatChar of(char c2) {
        FormatChar formatChar = MAP[FormatChar.indexOf(c2)];
        if (FormatChar.isLowerCase(c2)) {
            return formatChar;
        }
        return formatChar != null && formatChar.hasUpperCaseVariant() ? formatChar : null;
    }

    private FormatChar(char c2, FormatType formatType, String string2, boolean bl2) {
        this.formatChar = c2;
        this.type = formatType;
        this.allowedFlags = FormatOptions.parseValidFlags(string2, bl2);
        this.defaultFormatString = "%" + c2;
    }

    public char getChar() {
        return this.formatChar;
    }

    public FormatType getType() {
        return this.type;
    }

    int getAllowedFlags() {
        return this.allowedFlags;
    }

    private boolean hasUpperCaseVariant() {
        return (this.allowedFlags & 0x80) != 0;
    }

    public String getDefaultFormatString() {
        return this.defaultFormatString;
    }

    static {
        MAP = new FormatChar[26];
        FormatChar[] formatCharArray = FormatChar.values();
        int n2 = formatCharArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            FormatChar formatChar;
            FormatChar.MAP[FormatChar.indexOf((char)formatChar.getChar())] = formatChar = formatCharArray[i2];
        }
    }
}

