/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger;

import com.google.common.flogger.backend.KeyValueHandler;
import com.google.common.flogger.util.Checks;

public class MetadataKey<T> {
    private final String label;
    private final Class<T> clazz;
    private final boolean canRepeat;

    public static <T> MetadataKey<T> single(String string, Class<T> clazz) {
        return new MetadataKey<T>(string, clazz, false);
    }

    public static <T> MetadataKey<T> repeated(String string, Class<T> clazz) {
        return new MetadataKey<T>(string, clazz, true);
    }

    protected MetadataKey(String string, Class<T> clazz, boolean bl2) {
        this.label = Checks.checkMetadataIdentifier(string);
        this.clazz = Checks.checkNotNull(clazz, "class");
        this.canRepeat = bl2;
    }

    public final String getLabel() {
        return this.label;
    }

    public final T cast(Object object) {
        return this.clazz.cast(object);
    }

    public final boolean canRepeat() {
        return this.canRepeat;
    }

    public void emit(Object object, KeyValueHandler keyValueHandler) {
        keyValueHandler.handle(this.getLabel(), object);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object object) {
        return super.equals(object);
    }

    public final String toString() {
        return this.getClass().getName() + "/" + this.label + "[" + this.clazz.getName() + "]";
    }
}

