/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger;

import com.google.common.flogger.AbstractLogger;
import com.google.common.flogger.util.Checks;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@CheckReturnValue
public final class LoggerConfig {
    private static final Map<String, LoggerConfig> strongRefMap = new ConcurrentHashMap<String, LoggerConfig>();
    private final Logger logger;

    public static LoggerConfig of(AbstractLogger<?> abstractLogger) {
        Checks.checkArgument(abstractLogger.getName() != null, "cannot obtain configuration for an anonymous logger");
        return LoggerConfig.getConfig(abstractLogger.getName());
    }

    public static LoggerConfig getConfig(Class<?> clazz) {
        return LoggerConfig.getConfig(clazz.getName());
    }

    public static LoggerConfig getPackageConfig(Class<?> clazz) {
        return LoggerConfig.getConfig(clazz.getPackage().getName());
    }

    public static LoggerConfig getConfig(String string) {
        LoggerConfig loggerConfig = strongRefMap.get(Checks.checkNotNull(string, "logger name"));
        if (loggerConfig == null) {
            loggerConfig = new LoggerConfig(string);
            strongRefMap.put(string, loggerConfig);
        }
        return loggerConfig;
    }

    private LoggerConfig(String string) {
        this.logger = Checks.checkNotNull(Logger.getLogger(string), "logger");
    }

    @Nullable
    public ResourceBundle getResourceBundle() {
        return this.logger.getResourceBundle();
    }

    @Nullable
    public String getResourceBundleName() {
        return this.logger.getResourceBundleName();
    }

    public void setFilter(@Nullable Filter filter) {
        this.logger.setFilter(filter);
    }

    @Nullable
    public Filter getFilter() {
        return this.logger.getFilter();
    }

    public void setLevel(@Nullable Level level) {
        this.logger.setLevel(level);
    }

    @Nullable
    public Level getLevel() {
        return this.logger.getLevel();
    }

    public String getName() {
        return this.logger.getName();
    }

    public void addHandler(Handler handler) {
        Checks.checkNotNull(handler, "handler");
        this.logger.addHandler(handler);
    }

    public void removeHandler(Handler handler) {
        Checks.checkNotNull(handler, "handler");
        this.logger.removeHandler(handler);
    }

    public Handler[] getHandlers() {
        return this.logger.getHandlers();
    }

    public void setUseParentHandlers(boolean bl2) {
        this.logger.setUseParentHandlers(bl2);
    }

    public boolean getUseParentHandlers() {
        return this.logger.getUseParentHandlers();
    }

    @Nullable
    public Logger getParent() {
        return this.logger.getParent();
    }
}

