/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger;

import com.google.common.flogger.util.Checks;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class LogSiteStats {
    private static final StatsMap map = new StatsMap();
    private final AtomicLong invocationCount = new AtomicLong();
    private final AtomicLong lastTimestampNanos = new AtomicLong();
    private final AtomicInteger skippedLogStatements = new AtomicInteger();

    LogSiteStats() {
    }

    static RateLimitPeriod newRateLimitPeriod(int n2, TimeUnit timeUnit) {
        return new RateLimitPeriod(n2, timeUnit);
    }

    public static LogSiteStats getStatsForKey(Object object) {
        return map.getStatsForKey(object);
    }

    boolean incrementAndCheckInvocationCount(int n2) {
        return this.invocationCount.getAndIncrement() % (long)n2 == 0L;
    }

    boolean checkLastTimestamp(long l2, RateLimitPeriod rateLimitPeriod) {
        long l3 = this.lastTimestampNanos.get();
        long l4 = l3 + rateLimitPeriod.toNanos();
        if (l4 >= 0L && (l2 >= l4 || l3 == 0L) && this.lastTimestampNanos.compareAndSet(l3, l2)) {
            rateLimitPeriod.setSkipCount(this.skippedLogStatements.getAndSet(0));
            return true;
        }
        this.skippedLogStatements.incrementAndGet();
        return false;
    }

    static final class StatsMap {
        private final ConcurrentMap<Object, LogSiteStats> statsMap = new ConcurrentHashMap<Object, LogSiteStats>();

        StatsMap() {
        }

        LogSiteStats getStatsForKey(Object object) {
            LogSiteStats logSiteStats;
            LogSiteStats logSiteStats2 = (LogSiteStats)this.statsMap.get(object);
            if (logSiteStats2 == null && (logSiteStats = this.statsMap.putIfAbsent(object, logSiteStats2 = new LogSiteStats())) != null) {
                logSiteStats2 = logSiteStats;
            }
            return logSiteStats2;
        }
    }

    static final class RateLimitPeriod {
        private final int n;
        private final TimeUnit unit;
        private int skipCount = -1;

        private RateLimitPeriod(int n2, TimeUnit timeUnit) {
            if (n2 <= 0) {
                throw new IllegalArgumentException("time period must be positive: " + n2);
            }
            this.n = n2;
            this.unit = Checks.checkNotNull(timeUnit, "time unit");
        }

        private long toNanos() {
            return this.unit.toNanos(this.n);
        }

        private void setSkipCount(int n2) {
            this.skipCount = n2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append(this.n).append(' ').append((Object)this.unit);
            if (this.skipCount > 0) {
                stringBuilder.append(" [skipped: ").append(this.skipCount).append(']');
            }
            return stringBuilder.toString();
        }

        public int hashCode() {
            return this.n * 37 ^ this.unit.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof RateLimitPeriod) {
                RateLimitPeriod rateLimitPeriod = (RateLimitPeriod)object;
                return this.n == rateLimitPeriod.n && this.unit == rateLimitPeriod.unit;
            }
            return false;
        }
    }
}

