/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger;

import com.google.common.flogger.LogSiteKey;
import com.google.common.flogger.util.Checks;
import com.google.errorprone.annotations.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
public abstract class LogSite
implements LogSiteKey {
    public static final int UNKNOWN_LINE = 0;
    public static final LogSite INVALID = new LogSite(){

        @Override
        public String getClassName() {
            return "<unknown class>";
        }

        @Override
        public String getMethodName() {
            return "<unknown method>";
        }

        @Override
        public int getLineNumber() {
            return 0;
        }

        @Override
        public String getFileName() {
            return null;
        }
    };

    public abstract String getClassName();

    public abstract String getMethodName();

    public abstract int getLineNumber();

    public abstract String getFileName();

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("LogSite{ class=").append(this.getClassName()).append(", method=").append(this.getMethodName()).append(", line=").append(this.getLineNumber());
        if (this.getFileName() != null) {
            stringBuilder.append(", file=").append(this.getFileName());
        }
        return stringBuilder.append(" }").toString();
    }

    @Deprecated
    public static LogSite injectedLogSite(String string, String string2, int n2, @Nullable String string3) {
        return new InjectedLogSite(string, string2, n2, string3);
    }

    private static final class InjectedLogSite
    extends LogSite {
        private final String internalClassName;
        private final String methodName;
        private final int encodedLineNumber;
        private final String sourceFileName;
        private int hashcode = 0;

        private InjectedLogSite(String string, String string2, int n2, String string3) {
            this.internalClassName = Checks.checkNotNull(string, "class name");
            this.methodName = Checks.checkNotNull(string2, "method name");
            this.encodedLineNumber = n2;
            this.sourceFileName = string3;
        }

        @Override
        public String getClassName() {
            return this.internalClassName.replace('/', '.');
        }

        @Override
        public String getMethodName() {
            return this.methodName;
        }

        @Override
        public int getLineNumber() {
            return this.encodedLineNumber & 0xFFFF;
        }

        @Override
        public String getFileName() {
            return this.sourceFileName;
        }

        public boolean equals(Object object) {
            if (object instanceof InjectedLogSite) {
                InjectedLogSite injectedLogSite = (InjectedLogSite)object;
                return this.internalClassName.equals(injectedLogSite.internalClassName) && this.methodName.equals(injectedLogSite.methodName) && this.encodedLineNumber == injectedLogSite.encodedLineNumber;
            }
            return false;
        }

        public int hashCode() {
            if (this.hashcode == 0) {
                int n2 = 157;
                n2 = 31 * n2 + this.internalClassName.hashCode();
                n2 = 31 * n2 + this.methodName.hashCode();
                this.hashcode = n2 = 31 * n2 + this.encodedLineNumber;
            }
            return this.hashcode;
        }
    }
}

