/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger;

import com.google.common.flogger.AbstractLogger;
import com.google.common.flogger.LazyArg;
import com.google.common.flogger.LogSite;
import com.google.common.flogger.LogSiteKey;
import com.google.common.flogger.LogSiteStackTrace;
import com.google.common.flogger.LogSiteStats;
import com.google.common.flogger.LoggingApi;
import com.google.common.flogger.MetadataKey;
import com.google.common.flogger.StackSize;
import com.google.common.flogger.backend.LogData;
import com.google.common.flogger.backend.Metadata;
import com.google.common.flogger.backend.Platform;
import com.google.common.flogger.backend.Tags;
import com.google.common.flogger.backend.TemplateContext;
import com.google.common.flogger.parser.MessageParser;
import com.google.common.flogger.util.CallerFinder;
import com.google.common.flogger.util.Checks;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nullable;

@CheckReturnValue
public abstract class LogContext<LOGGER extends AbstractLogger<API>, API extends LoggingApi<API>>
implements LoggingApi<API>,
LogData {
    private static final String LITERAL_VALUE_MESSAGE = new String();
    private final Level level;
    private final long timestampNanos;
    private MutableMetadata metadata = null;
    private LogSite logSite = null;
    private TemplateContext templateContext = null;
    private Object[] args = null;

    protected LogContext(Level level, boolean bl2) {
        this(level, bl2, Platform.getCurrentTimeNanos());
    }

    protected LogContext(Level level, boolean bl2, long l2) {
        this.level = Checks.checkNotNull(level, "level");
        this.timestampNanos = l2;
        if (bl2) {
            this.addMetadata(Key.WAS_FORCED, Boolean.TRUE);
        }
    }

    protected abstract API api();

    protected abstract LOGGER getLogger();

    protected abstract API noOp();

    protected abstract MessageParser getMessageParser();

    @Override
    public final Level getLevel() {
        return this.level;
    }

    @Override
    @Deprecated
    public final long getTimestampMicros() {
        return TimeUnit.NANOSECONDS.toMicros(this.timestampNanos);
    }

    @Override
    public final long getTimestampNanos() {
        return this.timestampNanos;
    }

    @Override
    public final String getLoggerName() {
        return ((AbstractLogger)this.getLogger()).getBackend().getLoggerName();
    }

    @Override
    public final LogSite getLogSite() {
        if (this.logSite == null) {
            throw new IllegalStateException("cannot request log site information prior to postProcess()");
        }
        return this.logSite;
    }

    @Override
    public final TemplateContext getTemplateContext() {
        return this.templateContext;
    }

    @Override
    public final Object[] getArguments() {
        if (this.templateContext == null) {
            throw new IllegalStateException("cannot get arguments unless a template context exists");
        }
        return this.args;
    }

    @Override
    public final Object getLiteralArgument() {
        if (this.templateContext != null) {
            throw new IllegalStateException("cannot get literal argument if a template context exists");
        }
        return this.args[0];
    }

    @Override
    public final boolean wasForced() {
        return this.metadata != null && Boolean.TRUE.equals(this.metadata.findValue(Key.WAS_FORCED));
    }

    @Override
    public final Metadata getMetadata() {
        return this.metadata != null ? this.metadata : Metadata.empty();
    }

    protected final <T> void addMetadata(MetadataKey<T> metadataKey, T t2) {
        if (this.metadata == null) {
            this.metadata = new MutableMetadata();
        }
        this.metadata.addValue(metadataKey, t2);
    }

    protected final void removeMetadata(MetadataKey<?> metadataKey) {
        if (this.metadata != null) {
            this.metadata.removeAllValues(metadataKey);
        }
    }

    protected boolean postProcess(@Nullable LogSiteKey logSiteKey) {
        Object object;
        Object object2;
        if (this.metadata != null && logSiteKey != null) {
            object2 = this.metadata.findValue(Key.LOG_EVERY_N);
            object = this.metadata.findValue(Key.LOG_AT_MOST_EVERY);
            LogSiteStats logSiteStats = LogSiteStats.getStatsForKey(logSiteKey);
            if (object2 != null && !logSiteStats.incrementAndCheckInvocationCount((Integer)object2)) {
                return false;
            }
            if (object != null && !logSiteStats.checkLastTimestamp(this.getTimestampNanos(), (LogSiteStats.RateLimitPeriod)object)) {
                return false;
            }
        }
        if ((object2 = this.getMetadata().findValue(Key.CONTEXT_STACK_SIZE)) != null) {
            this.removeMetadata(Key.CONTEXT_STACK_SIZE);
            object = new LogSiteStackTrace(this.getMetadata().findValue(Key.LOG_CAUSE), (StackSize)((Object)object2), CallerFinder.getStackForCallerOf(LogContext.class, new Throwable(), ((StackSize)((Object)object2)).getMaxDepth()));
            this.addMetadata(Key.LOG_CAUSE, object);
        }
        return true;
    }

    private boolean shouldLog() {
        if (this.logSite == null) {
            this.logSite = Checks.checkNotNull(Platform.getCallerFinder().findLogSite(LogContext.class, 1), "logger backend must not return a null LogSite");
        }
        LogSite logSite = null;
        if (this.logSite != LogSite.INVALID) {
            logSite = this.logSite;
        }
        if (!this.postProcess(logSite)) {
            return false;
        }
        Tags tags = Platform.getInjectedTags();
        if (!tags.isEmpty()) {
            this.addMetadata(Key.TAGS, tags);
        }
        return true;
    }

    private void logImpl(String string, Object ... objectArray) {
        this.args = objectArray;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!(objectArray[i2] instanceof LazyArg)) continue;
            objectArray[i2] = ((LazyArg)objectArray[i2]).evaluate();
        }
        if (string != LITERAL_VALUE_MESSAGE) {
            this.templateContext = new TemplateContext(this.getMessageParser(), string);
        }
        ((AbstractLogger)this.getLogger()).write(this);
    }

    @Override
    public final API withInjectedLogSite(LogSite logSite) {
        if (this.logSite == null) {
            this.logSite = Checks.checkNotNull(logSite, "log site");
        }
        return this.api();
    }

    @Override
    public final API withInjectedLogSite(String string, String string2, int n2, @Nullable String string3) {
        return this.withInjectedLogSite(LogSite.injectedLogSite(string, string2, n2, string3));
    }

    @Override
    public final boolean isEnabled() {
        return this.wasForced() || ((AbstractLogger)this.getLogger()).isLoggable(this.level);
    }

    @Override
    public final API withCause(Throwable throwable) {
        if (throwable != null) {
            this.addMetadata(Key.LOG_CAUSE, throwable);
        }
        return this.api();
    }

    @Override
    public API withStackTrace(StackSize stackSize) {
        if (Checks.checkNotNull(stackSize, "stack size") != StackSize.NONE) {
            this.addMetadata(Key.CONTEXT_STACK_SIZE, stackSize);
        }
        return this.api();
    }

    @Override
    public final API every(int n2) {
        if (this.wasForced()) {
            return this.api();
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("rate limit count must be positive");
        }
        if (n2 > 1) {
            this.addMetadata(Key.LOG_EVERY_N, n2);
        }
        return this.api();
    }

    @Override
    public final API atMostEvery(int n2, TimeUnit timeUnit) {
        if (this.wasForced()) {
            return this.api();
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("rate limit period cannot be negative");
        }
        if (n2 > 0) {
            this.addMetadata(Key.LOG_AT_MOST_EVERY, LogSiteStats.newRateLimitPeriod(n2, timeUnit));
        }
        return this.api();
    }

    @Override
    public final void log() {
        if (this.shouldLog()) {
            this.logImpl(LITERAL_VALUE_MESSAGE, "");
        }
    }

    @Override
    public final void log(String string) {
        if (this.shouldLog()) {
            this.logImpl(LITERAL_VALUE_MESSAGE, string);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object) {
        if (this.shouldLog()) {
            this.logImpl(string, object);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, @Nullable Object object2) {
        if (this.shouldLog()) {
            this.logImpl(string, object, object2);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (this.shouldLog()) {
            this.logImpl(string, object, object2, object3);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3, @Nullable Object object4) {
        if (this.shouldLog()) {
            this.logImpl(string, object, object2, object3, object4);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3, @Nullable Object object4, @Nullable Object object5) {
        if (this.shouldLog()) {
            this.logImpl(string, object, object2, object3, object4, object5);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3, @Nullable Object object4, @Nullable Object object5, @Nullable Object object6) {
        if (this.shouldLog()) {
            this.logImpl(string, object, object2, object3, object4, object5, object6);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3, @Nullable Object object4, @Nullable Object object5, @Nullable Object object6, @Nullable Object object7) {
        if (this.shouldLog()) {
            this.logImpl(string, object, object2, object3, object4, object5, object6, object7);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3, @Nullable Object object4, @Nullable Object object5, @Nullable Object object6, @Nullable Object object7, @Nullable Object object8) {
        if (this.shouldLog()) {
            this.logImpl(string, object, object2, object3, object4, object5, object6, object7, object8);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3, @Nullable Object object4, @Nullable Object object5, @Nullable Object object6, @Nullable Object object7, @Nullable Object object8, @Nullable Object object9) {
        if (this.shouldLog()) {
            this.logImpl(string, object, object2, object3, object4, object5, object6, object7, object8, object9);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3, @Nullable Object object4, @Nullable Object object5, @Nullable Object object6, @Nullable Object object7, @Nullable Object object8, @Nullable Object object9, @Nullable Object object10) {
        if (this.shouldLog()) {
            this.logImpl(string, object, object2, object3, object4, object5, object6, object7, object8, object9, object10);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3, @Nullable Object object4, @Nullable Object object5, @Nullable Object object6, @Nullable Object object7, @Nullable Object object8, @Nullable Object object9, @Nullable Object object10, Object ... objectArray) {
        if (this.shouldLog()) {
            Object[] objectArray2 = new Object[objectArray.length + 10];
            objectArray2[0] = object;
            objectArray2[1] = object2;
            objectArray2[2] = object3;
            objectArray2[3] = object4;
            objectArray2[4] = object5;
            objectArray2[5] = object6;
            objectArray2[6] = object7;
            objectArray2[7] = object8;
            objectArray2[8] = object9;
            objectArray2[9] = object10;
            System.arraycopy(objectArray, 0, objectArray2, 10, objectArray.length);
            this.logImpl(string, objectArray2);
        }
    }

    @Override
    public final void log(String string, char c2) {
        if (this.shouldLog()) {
            this.logImpl(string, Character.valueOf(c2));
        }
    }

    @Override
    public final void log(String string, byte by2) {
        if (this.shouldLog()) {
            this.logImpl(string, by2);
        }
    }

    @Override
    public final void log(String string, short s2) {
        if (this.shouldLog()) {
            this.logImpl(string, s2);
        }
    }

    @Override
    public final void log(String string, int n2) {
        if (this.shouldLog()) {
            this.logImpl(string, n2);
        }
    }

    @Override
    public final void log(String string, long l2) {
        if (this.shouldLog()) {
            this.logImpl(string, l2);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, boolean bl2) {
        if (this.shouldLog()) {
            this.logImpl(string, object, bl2);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, char c2) {
        if (this.shouldLog()) {
            this.logImpl(string, object, Character.valueOf(c2));
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, byte by2) {
        if (this.shouldLog()) {
            this.logImpl(string, object, by2);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, short s2) {
        if (this.shouldLog()) {
            this.logImpl(string, object, s2);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, int n2) {
        if (this.shouldLog()) {
            this.logImpl(string, object, n2);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, long l2) {
        if (this.shouldLog()) {
            this.logImpl(string, object, l2);
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, float f2) {
        if (this.shouldLog()) {
            this.logImpl(string, object, Float.valueOf(f2));
        }
    }

    @Override
    public final void log(String string, @Nullable Object object, double d2) {
        if (this.shouldLog()) {
            this.logImpl(string, object, d2);
        }
    }

    @Override
    public final void log(String string, boolean bl2, @Nullable Object object) {
        if (this.shouldLog()) {
            this.logImpl(string, bl2, object);
        }
    }

    @Override
    public final void log(String string, char c2, @Nullable Object object) {
        if (this.shouldLog()) {
            this.logImpl(string, Character.valueOf(c2), object);
        }
    }

    @Override
    public final void log(String string, byte by2, @Nullable Object object) {
        if (this.shouldLog()) {
            this.logImpl(string, by2, object);
        }
    }

    @Override
    public final void log(String string, short s2, @Nullable Object object) {
        if (this.shouldLog()) {
            this.logImpl(string, s2, object);
        }
    }

    @Override
    public final void log(String string, int n2, @Nullable Object object) {
        if (this.shouldLog()) {
            this.logImpl(string, n2, object);
        }
    }

    @Override
    public final void log(String string, long l2, @Nullable Object object) {
        if (this.shouldLog()) {
            this.logImpl(string, l2, object);
        }
    }

    @Override
    public final void log(String string, float f2, @Nullable Object object) {
        if (this.shouldLog()) {
            this.logImpl(string, Float.valueOf(f2), object);
        }
    }

    @Override
    public final void log(String string, double d2, @Nullable Object object) {
        if (this.shouldLog()) {
            this.logImpl(string, d2, object);
        }
    }

    @Override
    public final void log(String string, boolean bl2, boolean bl3) {
        if (this.shouldLog()) {
            this.logImpl(string, bl2, bl3);
        }
    }

    @Override
    public final void log(String string, char c2, boolean bl2) {
        if (this.shouldLog()) {
            this.logImpl(string, Character.valueOf(c2), bl2);
        }
    }

    @Override
    public final void log(String string, byte by2, boolean bl2) {
        if (this.shouldLog()) {
            this.logImpl(string, by2, bl2);
        }
    }

    @Override
    public final void log(String string, short s2, boolean bl2) {
        if (this.shouldLog()) {
            this.logImpl(string, s2, bl2);
        }
    }

    @Override
    public final void log(String string, int n2, boolean bl2) {
        if (this.shouldLog()) {
            this.logImpl(string, n2, bl2);
        }
    }

    @Override
    public final void log(String string, long l2, boolean bl2) {
        if (this.shouldLog()) {
            this.logImpl(string, l2, bl2);
        }
    }

    @Override
    public final void log(String string, float f2, boolean bl2) {
        if (this.shouldLog()) {
            this.logImpl(string, Float.valueOf(f2), bl2);
        }
    }

    @Override
    public final void log(String string, double d2, boolean bl2) {
        if (this.shouldLog()) {
            this.logImpl(string, d2, bl2);
        }
    }

    @Override
    public final void log(String string, boolean bl2, char c2) {
        if (this.shouldLog()) {
            this.logImpl(string, bl2, Character.valueOf(c2));
        }
    }

    @Override
    public final void log(String string, char c2, char c3) {
        if (this.shouldLog()) {
            this.logImpl(string, Character.valueOf(c2), Character.valueOf(c3));
        }
    }

    @Override
    public final void log(String string, byte by2, char c2) {
        if (this.shouldLog()) {
            this.logImpl(string, by2, Character.valueOf(c2));
        }
    }

    @Override
    public final void log(String string, short s2, char c2) {
        if (this.shouldLog()) {
            this.logImpl(string, s2, Character.valueOf(c2));
        }
    }

    @Override
    public final void log(String string, int n2, char c2) {
        if (this.shouldLog()) {
            this.logImpl(string, n2, Character.valueOf(c2));
        }
    }

    @Override
    public final void log(String string, long l2, char c2) {
        if (this.shouldLog()) {
            this.logImpl(string, l2, Character.valueOf(c2));
        }
    }

    @Override
    public final void log(String string, float f2, char c2) {
        if (this.shouldLog()) {
            this.logImpl(string, Float.valueOf(f2), Character.valueOf(c2));
        }
    }

    @Override
    public final void log(String string, double d2, char c2) {
        if (this.shouldLog()) {
            this.logImpl(string, d2, Character.valueOf(c2));
        }
    }

    @Override
    public final void log(String string, boolean bl2, byte by2) {
        if (this.shouldLog()) {
            this.logImpl(string, bl2, by2);
        }
    }

    @Override
    public final void log(String string, char c2, byte by2) {
        if (this.shouldLog()) {
            this.logImpl(string, Character.valueOf(c2), by2);
        }
    }

    @Override
    public final void log(String string, byte by2, byte by3) {
        if (this.shouldLog()) {
            this.logImpl(string, by2, by3);
        }
    }

    @Override
    public final void log(String string, short s2, byte by2) {
        if (this.shouldLog()) {
            this.logImpl(string, s2, by2);
        }
    }

    @Override
    public final void log(String string, int n2, byte by2) {
        if (this.shouldLog()) {
            this.logImpl(string, n2, by2);
        }
    }

    @Override
    public final void log(String string, long l2, byte by2) {
        if (this.shouldLog()) {
            this.logImpl(string, l2, by2);
        }
    }

    @Override
    public final void log(String string, float f2, byte by2) {
        if (this.shouldLog()) {
            this.logImpl(string, Float.valueOf(f2), by2);
        }
    }

    @Override
    public final void log(String string, double d2, byte by2) {
        if (this.shouldLog()) {
            this.logImpl(string, d2, by2);
        }
    }

    @Override
    public final void log(String string, boolean bl2, short s2) {
        if (this.shouldLog()) {
            this.logImpl(string, bl2, s2);
        }
    }

    @Override
    public final void log(String string, char c2, short s2) {
        if (this.shouldLog()) {
            this.logImpl(string, Character.valueOf(c2), s2);
        }
    }

    @Override
    public final void log(String string, byte by2, short s2) {
        if (this.shouldLog()) {
            this.logImpl(string, by2, s2);
        }
    }

    @Override
    public final void log(String string, short s2, short s3) {
        if (this.shouldLog()) {
            this.logImpl(string, s2, s3);
        }
    }

    @Override
    public final void log(String string, int n2, short s2) {
        if (this.shouldLog()) {
            this.logImpl(string, n2, s2);
        }
    }

    @Override
    public final void log(String string, long l2, short s2) {
        if (this.shouldLog()) {
            this.logImpl(string, l2, s2);
        }
    }

    @Override
    public final void log(String string, float f2, short s2) {
        if (this.shouldLog()) {
            this.logImpl(string, Float.valueOf(f2), s2);
        }
    }

    @Override
    public final void log(String string, double d2, short s2) {
        if (this.shouldLog()) {
            this.logImpl(string, d2, s2);
        }
    }

    @Override
    public final void log(String string, boolean bl2, int n2) {
        if (this.shouldLog()) {
            this.logImpl(string, bl2, n2);
        }
    }

    @Override
    public final void log(String string, char c2, int n2) {
        if (this.shouldLog()) {
            this.logImpl(string, Character.valueOf(c2), n2);
        }
    }

    @Override
    public final void log(String string, byte by2, int n2) {
        if (this.shouldLog()) {
            this.logImpl(string, by2, n2);
        }
    }

    @Override
    public final void log(String string, short s2, int n2) {
        if (this.shouldLog()) {
            this.logImpl(string, s2, n2);
        }
    }

    @Override
    public final void log(String string, int n2, int n3) {
        if (this.shouldLog()) {
            this.logImpl(string, n2, n3);
        }
    }

    @Override
    public final void log(String string, long l2, int n2) {
        if (this.shouldLog()) {
            this.logImpl(string, l2, n2);
        }
    }

    @Override
    public final void log(String string, float f2, int n2) {
        if (this.shouldLog()) {
            this.logImpl(string, Float.valueOf(f2), n2);
        }
    }

    @Override
    public final void log(String string, double d2, int n2) {
        if (this.shouldLog()) {
            this.logImpl(string, d2, n2);
        }
    }

    @Override
    public final void log(String string, boolean bl2, long l2) {
        if (this.shouldLog()) {
            this.logImpl(string, bl2, l2);
        }
    }

    @Override
    public final void log(String string, char c2, long l2) {
        if (this.shouldLog()) {
            this.logImpl(string, Character.valueOf(c2), l2);
        }
    }

    @Override
    public final void log(String string, byte by2, long l2) {
        if (this.shouldLog()) {
            this.logImpl(string, by2, l2);
        }
    }

    @Override
    public final void log(String string, short s2, long l2) {
        if (this.shouldLog()) {
            this.logImpl(string, s2, l2);
        }
    }

    @Override
    public final void log(String string, int n2, long l2) {
        if (this.shouldLog()) {
            this.logImpl(string, n2, l2);
        }
    }

    @Override
    public final void log(String string, long l2, long l3) {
        if (this.shouldLog()) {
            this.logImpl(string, l2, l3);
        }
    }

    @Override
    public final void log(String string, float f2, long l2) {
        if (this.shouldLog()) {
            this.logImpl(string, Float.valueOf(f2), l2);
        }
    }

    @Override
    public final void log(String string, double d2, long l2) {
        if (this.shouldLog()) {
            this.logImpl(string, d2, l2);
        }
    }

    @Override
    public final void log(String string, boolean bl2, float f2) {
        if (this.shouldLog()) {
            this.logImpl(string, bl2, Float.valueOf(f2));
        }
    }

    @Override
    public final void log(String string, char c2, float f2) {
        if (this.shouldLog()) {
            this.logImpl(string, Character.valueOf(c2), Float.valueOf(f2));
        }
    }

    @Override
    public final void log(String string, byte by2, float f2) {
        if (this.shouldLog()) {
            this.logImpl(string, by2, Float.valueOf(f2));
        }
    }

    @Override
    public final void log(String string, short s2, float f2) {
        if (this.shouldLog()) {
            this.logImpl(string, s2, Float.valueOf(f2));
        }
    }

    @Override
    public final void log(String string, int n2, float f2) {
        if (this.shouldLog()) {
            this.logImpl(string, n2, Float.valueOf(f2));
        }
    }

    @Override
    public final void log(String string, long l2, float f2) {
        if (this.shouldLog()) {
            this.logImpl(string, l2, Float.valueOf(f2));
        }
    }

    @Override
    public final void log(String string, float f2, float f3) {
        if (this.shouldLog()) {
            this.logImpl(string, Float.valueOf(f2), Float.valueOf(f3));
        }
    }

    @Override
    public final void log(String string, double d2, float f2) {
        if (this.shouldLog()) {
            this.logImpl(string, d2, Float.valueOf(f2));
        }
    }

    @Override
    public final void log(String string, boolean bl2, double d2) {
        if (this.shouldLog()) {
            this.logImpl(string, bl2, d2);
        }
    }

    @Override
    public final void log(String string, char c2, double d2) {
        if (this.shouldLog()) {
            this.logImpl(string, Character.valueOf(c2), d2);
        }
    }

    @Override
    public final void log(String string, byte by2, double d2) {
        if (this.shouldLog()) {
            this.logImpl(string, by2, d2);
        }
    }

    @Override
    public final void log(String string, short s2, double d2) {
        if (this.shouldLog()) {
            this.logImpl(string, s2, d2);
        }
    }

    @Override
    public final void log(String string, int n2, double d2) {
        if (this.shouldLog()) {
            this.logImpl(string, n2, d2);
        }
    }

    @Override
    public final void log(String string, long l2, double d2) {
        if (this.shouldLog()) {
            this.logImpl(string, l2, d2);
        }
    }

    @Override
    public final void log(String string, float f2, double d2) {
        if (this.shouldLog()) {
            this.logImpl(string, Float.valueOf(f2), d2);
        }
    }

    @Override
    public final void log(String string, double d2, double d3) {
        if (this.shouldLog()) {
            this.logImpl(string, d2, d3);
        }
    }

    @Override
    public final void logVarargs(String string, Object[] objectArray) {
        if (this.shouldLog()) {
            this.logImpl(string, Arrays.copyOf(objectArray, objectArray.length));
        }
    }

    static final class MutableMetadata
    extends Metadata {
        private static final int INITIAL_KEY_VALUE_CAPACITY = 4;
        private Object[] keyValuePairs = new Object[8];
        private int keyValueCount = 0;

        MutableMetadata() {
        }

        @Override
        public int size() {
            return this.keyValueCount;
        }

        @Override
        public MetadataKey<?> getKey(int n2) {
            if (n2 >= this.keyValueCount) {
                throw new IndexOutOfBoundsException();
            }
            return (MetadataKey)this.keyValuePairs[2 * n2];
        }

        @Override
        public Object getValue(int n2) {
            if (n2 >= this.keyValueCount) {
                throw new IndexOutOfBoundsException();
            }
            return this.keyValuePairs[2 * n2 + 1];
        }

        private int indexOf(MetadataKey<?> metadataKey) {
            for (int i2 = 0; i2 < this.keyValueCount; ++i2) {
                if (!this.keyValuePairs[2 * i2].equals(metadataKey)) continue;
                return i2;
            }
            return -1;
        }

        @Override
        @Nullable
        public <T> T findValue(MetadataKey<T> metadataKey) {
            int n2 = this.indexOf(metadataKey);
            return n2 != -1 ? (T)metadataKey.cast(this.keyValuePairs[2 * n2 + 1]) : null;
        }

        <T> void addValue(MetadataKey<T> metadataKey, T t2) {
            int n2;
            if (!metadataKey.canRepeat() && (n2 = this.indexOf(metadataKey)) != -1) {
                this.keyValuePairs[2 * n2 + 1] = Checks.checkNotNull(t2, "metadata value");
                return;
            }
            if (2 * (this.keyValueCount + 1) > this.keyValuePairs.length) {
                this.keyValuePairs = Arrays.copyOf(this.keyValuePairs, 2 * this.keyValuePairs.length);
            }
            this.keyValuePairs[2 * this.keyValueCount] = Checks.checkNotNull(metadataKey, "metadata key");
            this.keyValuePairs[2 * this.keyValueCount + 1] = Checks.checkNotNull(t2, "metadata value");
            ++this.keyValueCount;
        }

        void removeAllValues(MetadataKey<?> metadataKey) {
            int n2 = this.indexOf(metadataKey);
            if (n2 >= 0) {
                int n3;
                int n4 = 2 * n2;
                for (n3 = n4 + 2; n3 < 2 * this.keyValueCount; n3 += 2) {
                    Object object = this.keyValuePairs[n3];
                    if (object.equals(metadataKey)) continue;
                    this.keyValuePairs[n4] = object;
                    this.keyValuePairs[n4 + 1] = this.keyValuePairs[n3 + 1];
                    n4 += 2;
                }
                this.keyValueCount -= n3 - n4 >> 1;
                while (n4 < n3) {
                    this.keyValuePairs[n4++] = null;
                }
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Metadata{");
            for (int i2 = 0; i2 < this.size(); ++i2) {
                stringBuilder.append(" '").append(this.getKey(i2)).append("': ").append(this.getValue(i2));
            }
            return stringBuilder.append(" }").toString();
        }
    }

    public static final class Key {
        public static final MetadataKey<Throwable> LOG_CAUSE = MetadataKey.single("cause", Throwable.class);
        public static final MetadataKey<Integer> LOG_EVERY_N = MetadataKey.single("ratelimit_count", Integer.class);
        public static final MetadataKey<LogSiteStats.RateLimitPeriod> LOG_AT_MOST_EVERY = MetadataKey.single("ratelimit_period", LogSiteStats.RateLimitPeriod.class);
        public static final MetadataKey<Boolean> WAS_FORCED = MetadataKey.single("forced", Boolean.class);
        public static final MetadataKey<Tags> TAGS = MetadataKey.single("tags", Tags.class);
        public static final MetadataKey<StackSize> CONTEXT_STACK_SIZE = MetadataKey.single("stack_size", StackSize.class);

        private Key() {
        }
    }
}

