/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.Escaper;
import com.google.common.escape.Platform;

@Beta
@GwtCompatible
public abstract class UnicodeEscaper
extends Escaper {
    private static final int DEST_PAD = 32;

    protected UnicodeEscaper() {
    }

    protected abstract char[] escape(int var1);

    @Override
    public String escape(String string) {
        Preconditions.checkNotNull(string);
        int n2 = string.length();
        int n3 = this.nextEscapeIndex(string, 0, n2);
        return n3 == n2 ? string : this.escapeSlow(string, n3);
    }

    protected int nextEscapeIndex(CharSequence charSequence, int n2, int n3) {
        int n4;
        int n5;
        for (n4 = n2; n4 < n3 && (n5 = UnicodeEscaper.codePointAt(charSequence, n4, n3)) >= 0 && this.escape(n5) == null; n4 += Character.isSupplementaryCodePoint(n5) ? 2 : 1) {
        }
        return n4;
    }

    protected final String escapeSlow(String string, int n2) {
        int n3;
        int n4 = string.length();
        char[] cArray = Platform.charBufferFromThreadLocal();
        int n5 = 0;
        int n6 = 0;
        while (n2 < n4) {
            n3 = UnicodeEscaper.codePointAt(string, n2, n4);
            if (n3 < 0) {
                throw new IllegalArgumentException("Trailing high surrogate at end of input");
            }
            char[] cArray2 = this.escape(n3);
            int n7 = n2 + (Character.isSupplementaryCodePoint(n3) ? 2 : 1);
            if (cArray2 != null) {
                int n8 = n2 - n6;
                int n9 = n5 + n8 + cArray2.length;
                if (cArray.length < n9) {
                    int n10 = n9 + (n4 - n2) + 32;
                    cArray = UnicodeEscaper.growBuffer(cArray, n5, n10);
                }
                if (n8 > 0) {
                    string.getChars(n6, n2, cArray, n5);
                    n5 += n8;
                }
                if (cArray2.length > 0) {
                    System.arraycopy(cArray2, 0, cArray, n5, cArray2.length);
                    n5 += cArray2.length;
                }
                n6 = n7;
            }
            n2 = this.nextEscapeIndex(string, n7, n4);
        }
        n3 = n4 - n6;
        if (n3 > 0) {
            int n11 = n5 + n3;
            if (cArray.length < n11) {
                cArray = UnicodeEscaper.growBuffer(cArray, n5, n11);
            }
            string.getChars(n6, n4, cArray, n5);
            n5 = n11;
        }
        return new String(cArray, 0, n5);
    }

    protected static int codePointAt(CharSequence charSequence, int n2, int n3) {
        Preconditions.checkNotNull(charSequence);
        if (n2 < n3) {
            char c2;
            if ((c2 = charSequence.charAt(n2++)) < '\ud800' || c2 > '\udfff') {
                return c2;
            }
            if (c2 <= '\udbff') {
                if (n2 == n3) {
                    return -c2;
                }
                char c3 = charSequence.charAt(n2);
                if (Character.isLowSurrogate(c3)) {
                    return Character.toCodePoint(c2, c3);
                }
                throw new IllegalArgumentException("Expected low surrogate but got char '" + c3 + "' with value " + c3 + " at index " + n2 + " in '" + charSequence + "'");
            }
            throw new IllegalArgumentException("Unexpected low surrogate character '" + c2 + "' with value " + c2 + " at index " + (n2 - 1) + " in '" + charSequence + "'");
        }
        throw new IndexOutOfBoundsException("Index exceeds specified range");
    }

    private static char[] growBuffer(char[] cArray, int n2, int n3) {
        if (n3 < 0) {
            throw new AssertionError((Object)"Cannot increase internal buffer any further");
        }
        char[] cArray2 = new char[n3];
        if (n2 > 0) {
            System.arraycopy(cArray, 0, cArray2, 0, n2);
        }
        return cArray2;
    }
}

