/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.ArrayBasedCharEscaper;
import com.google.common.escape.CharEscaper;
import com.google.common.escape.Escaper;
import com.google.common.escape.UnicodeEscaper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
@GwtCompatible
public final class Escapers {
    private static final Escaper NULL_ESCAPER = new CharEscaper(){

        @Override
        public String escape(String string) {
            return Preconditions.checkNotNull(string);
        }

        @Override
        protected char[] escape(char c2) {
            return null;
        }
    };

    private Escapers() {
    }

    public static Escaper nullEscaper() {
        return NULL_ESCAPER;
    }

    public static Builder builder() {
        return new Builder();
    }

    static UnicodeEscaper asUnicodeEscaper(Escaper escaper) {
        Preconditions.checkNotNull(escaper);
        if (escaper instanceof UnicodeEscaper) {
            return (UnicodeEscaper)escaper;
        }
        if (escaper instanceof CharEscaper) {
            return Escapers.wrap((CharEscaper)escaper);
        }
        throw new IllegalArgumentException("Cannot create a UnicodeEscaper from: " + escaper.getClass().getName());
    }

    public static String computeReplacement(CharEscaper charEscaper, char c2) {
        return Escapers.stringOrNull(charEscaper.escape(c2));
    }

    public static String computeReplacement(UnicodeEscaper unicodeEscaper, int n2) {
        return Escapers.stringOrNull(unicodeEscaper.escape(n2));
    }

    private static String stringOrNull(char[] cArray) {
        return cArray == null ? null : new String(cArray);
    }

    private static UnicodeEscaper wrap(final CharEscaper charEscaper) {
        return new UnicodeEscaper(){

            @Override
            protected char[] escape(int n2) {
                int n3;
                if (n2 < 65536) {
                    return charEscaper.escape((char)n2);
                }
                char[] cArray = new char[2];
                Character.toChars(n2, cArray, 0);
                char[] cArray2 = charEscaper.escape(cArray[0]);
                char[] cArray3 = charEscaper.escape(cArray[1]);
                if (cArray2 == null && cArray3 == null) {
                    return null;
                }
                int n4 = cArray2 != null ? cArray2.length : 1;
                int n5 = cArray3 != null ? cArray3.length : 1;
                char[] cArray4 = new char[n4 + n5];
                if (cArray2 != null) {
                    for (n3 = 0; n3 < cArray2.length; ++n3) {
                        cArray4[n3] = cArray2[n3];
                    }
                } else {
                    cArray4[0] = cArray[0];
                }
                if (cArray3 != null) {
                    for (n3 = 0; n3 < cArray3.length; ++n3) {
                        cArray4[n4 + n3] = cArray3[n3];
                    }
                } else {
                    cArray4[n4] = cArray[1];
                }
                return cArray4;
            }
        };
    }

    @Beta
    public static final class Builder {
        private final Map<Character, String> replacementMap = new HashMap<Character, String>();
        private char safeMin = '\u0000';
        private char safeMax = (char)65535;
        private String unsafeReplacement = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder setSafeRange(char c2, char c3) {
            this.safeMin = c2;
            this.safeMax = c3;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUnsafeReplacement(@Nullable String string) {
            this.unsafeReplacement = string;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addEscape(char c2, String string) {
            Preconditions.checkNotNull(string);
            this.replacementMap.put(Character.valueOf(c2), string);
            return this;
        }

        public Escaper build() {
            return new ArrayBasedCharEscaper(this.replacementMap, this.safeMin, this.safeMax){
                private final char[] replacementChars;
                {
                    super(map, c2, c3);
                    this.replacementChars = unsafeReplacement != null ? unsafeReplacement.toCharArray() : null;
                }

                @Override
                protected char[] escapeUnsafe(char c2) {
                    return this.replacementChars;
                }
            };
        }
    }
}

