/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.CharEscaper;
import com.google.common.escape.Escaper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.Map;

@Beta
@GwtCompatible
public final class CharEscaperBuilder {
    private final Map<Character, String> map = new HashMap<Character, String>();
    private int max = -1;

    @CanIgnoreReturnValue
    public CharEscaperBuilder addEscape(char c2, String string) {
        this.map.put(Character.valueOf(c2), Preconditions.checkNotNull(string));
        if (c2 > this.max) {
            this.max = c2;
        }
        return this;
    }

    @CanIgnoreReturnValue
    public CharEscaperBuilder addEscapes(char[] cArray, String string) {
        Preconditions.checkNotNull(string);
        for (char c2 : cArray) {
            this.addEscape(c2, string);
        }
        return this;
    }

    public char[][] toArray() {
        char[][] cArrayArray = new char[this.max + 1][];
        for (Map.Entry<Character, String> entry : this.map.entrySet()) {
            cArrayArray[entry.getKey().charValue()] = entry.getValue().toCharArray();
        }
        return cArrayArray;
    }

    public Escaper toEscaper() {
        return new CharArrayDecorator(this.toArray());
    }

    private static class CharArrayDecorator
    extends CharEscaper {
        private final char[][] replacements;
        private final int replaceLength;

        CharArrayDecorator(char[][] cArray) {
            this.replacements = cArray;
            this.replaceLength = cArray.length;
        }

        @Override
        public String escape(String string) {
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 >= this.replacements.length || this.replacements[c2] == null) continue;
                return this.escapeSlow(string, i2);
            }
            return string;
        }

        @Override
        protected char[] escape(char c2) {
            return c2 < this.replaceLength ? this.replacements[c2] : null;
        }
    }
}

