/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.Escaper;
import com.google.common.escape.Platform;

@Beta
@GwtCompatible
public abstract class CharEscaper
extends Escaper {
    private static final int DEST_PAD_MULTIPLIER = 2;

    protected CharEscaper() {
    }

    @Override
    public String escape(String string) {
        Preconditions.checkNotNull(string);
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.escape(string.charAt(i2)) == null) continue;
            return this.escapeSlow(string, i2);
        }
        return string;
    }

    protected abstract char[] escape(char var1);

    protected final String escapeSlow(String string, int n2) {
        int n3;
        int n4 = string.length();
        char[] cArray = Platform.charBufferFromThreadLocal();
        int n5 = cArray.length;
        int n6 = 0;
        int n7 = 0;
        while (n2 < n4) {
            char[] cArray2 = this.escape(string.charAt(n2));
            if (cArray2 != null) {
                int n8 = n2 - n7;
                n3 = cArray2.length;
                int n9 = n6 + n8 + n3;
                if (n5 < n9) {
                    n5 = n9 + 2 * (n4 - n2);
                    cArray = CharEscaper.growBuffer(cArray, n6, n5);
                }
                if (n8 > 0) {
                    string.getChars(n7, n2, cArray, n6);
                    n6 += n8;
                }
                if (n3 > 0) {
                    System.arraycopy(cArray2, 0, cArray, n6, n3);
                    n6 += n3;
                }
                n7 = n2 + 1;
            }
            ++n2;
        }
        int n10 = n4 - n7;
        if (n10 > 0) {
            n3 = n6 + n10;
            if (n5 < n3) {
                cArray = CharEscaper.growBuffer(cArray, n6, n3);
            }
            string.getChars(n7, n4, cArray, n6);
            n6 = n3;
        }
        return new String(cArray, 0, n6);
    }

    private static char[] growBuffer(char[] cArray, int n2, int n3) {
        if (n3 < 0) {
            throw new AssertionError((Object)"Cannot increase internal buffer any further");
        }
        char[] cArray2 = new char[n3];
        if (n2 > 0) {
            System.arraycopy(cArray, 0, cArray2, 0, n2);
        }
        return cArray2;
    }
}

